<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Color
 *
 * @package App
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property string $groupNo
 * @property string $breedNo
 * @property string $colorNo
 * @property string $colorName
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereBreedNo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereColorName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereColorNo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereGroupNo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Color whereUpdatedAt($value)
 */
class Color extends Model
{
    /**
     * @var array
     */
    protected $fillable = [
        'groupNo',
        'breedNo',
        'colorNo',
        'colorName'
    ];   //
}
