@extends('layouts.app')

@section('content')

    <div class="uk-container">
        <div class="uk-grid">
            <div class="uk-width-3-4@m">
                <h2> Aussteller auswählen</h2>
                <p>{{trans_choice("exhibitor.max_exhibitors",Auth::user()->maxExhibitors,["value" => Auth::user()->maxExhibitors])}} <br/>
                    <small>Sollten Sie mehr Austeller benötigen setzen Sie bitte mit uns in Kontakt</small>
                </p>
                @if(Auth::user()->maxExhibitors > $exhibitors->count()  or Auth::user()->isAdmin)
                <a href="/exhibitor/create">Aussteller hinzufügen</a>
                @endif()
            </div>
            <div class="uk-width-1-4@m">
                <a class="uk-button uk-button-primary" href="/exhibition"> Zu den Ausstellungen</a>
            </div>
        </div>
        <hr>
        <div class="card-deck" uk-grid>
            @isset($exhibitors)
                @each('exhibitor.cards',$exhibitors,'exhibitor')
            @endisset
        </div>
    </div>

@endsection
