<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1 ">

    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Scripts -->
    <script>
        @stack('js-data')
    </script>
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="https://fonts.gstatic.com">
{{--<link href="https://fonts.googleapis.com/css?family=Raleway:300,400,600" rel="stylesheet" type="text/css">--}}

<!-- Styles -->

</head>
<body>
<div id="app">
    @include('layouts.partials.navigation')

    <main class="uk-visible@m@m">
        @yield('content')
    </main>

    <div class="uk-container uk-hidden@m">
        <div class="uk-card uk-card-default">
            <div class="uk-card-header">Orientierung ändern oder Endgerät wechseln</div>
            <div class="uk-card-body">
                Vielen Dank für Ihr Interesse am amadeus Onlinemeldebogen.<br/>
                <br/>
                Bitte verwenden Sie einen Desktop PC oder ein Tablet.<br/>
                <br/>
                Verwenden Sie bereits ein Tablet, halten sie dieses bitte quer.<br/>
                <br/>
                Smartphones werden <u>nicht</u> unterstützt.
            </div>
        </div>
    </div>

    <div id="mainModal" uk-modal>
        <div class="uk-modal-dialog" role="document">
            @yield('modal')
        </div>
    </div>

    <footer class="uk-container uk-margin-large-top uk-margin-small-bottom">
        <div class="uk-grid">
        <div class="uk-text-left uk-width-1-2@m">
            <small class="uk-text-muted">{{config('app.version')}}</small>
        </div>
        <div class="uk-text-right@m uk-width-1-2@m">
            <small class="uk-text-muted"><a href="{{route('imprint')}}">Impressum</a> | <a
                        href="{{route('dataprotection')}}">Datenschutzerklärung</a></small>
        </div>
        </div>
    </footer>
</div>

</body>
</html>
