<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * App\Registration
 *
 * @property mixed exhibitorId
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property int $exhibitionId
 * @property int $userId
 * @property int $exhibitorId
 * @property int $amount_special
 * @property int $amount_specialBonus
 * @property int $amount_prize
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @property \Carbon\Carbon|null $deleted_at
 * @method static bool|null forceDelete()
 * @method static \Illuminate\Database\Query\Builder|\App\Registration onlyTrashed()
 * @method static bool|null restore()
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereAmountPrize($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereAmountSpecial($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereAmountSpecialBonus($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereDeletedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereExhibitionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereExhibitorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereUserId($value)
 * @method static \Illuminate\Database\Query\Builder|\App\Registration withTrashed()
 * @method static \Illuminate\Database\Query\Builder|\App\Registration withoutTrashed()
 * @property int $locked
 * @property int $is_judge
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereIsJudge($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Registration whereLocked($value)
 */
class Registration extends Model
{
    use SoftDeletes;

    /**
     * @var array
     */
    protected $dates = ['deleted_at'];

}
