<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateExhibitorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('exhibitors', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('userId');
            $table->string("firstName")->nullable();
            $table->string("lastName")->nullable();
            $table->string("address")->nullable();
            $table->string("zip")->nullable();
            $table->string("city")->nullable();
            $table->string("telephone")->nullable();
            $table->string("bankName")->nullable();
            $table->string("bankAccountOwner")->nullable();
            $table->string("iban")->nullable();
            $table->string("regno")->nullable();
            $table->string("vet")->nullable();
            $table->string("society")->nullable();
            $table->tinyInteger('type')->nullable();
            $table->boolean('isJudge')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('exhibitors');
    }
}
