<?php

namespace App\Helper;
/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 25.09.18
 * Time: 15:15
 */


use App\Animal;
use App\AnimalAviary;
use App\AnimalPair;
use App\Breed;
use App\Color;
use App\Registration;


class FixHelper
{

    public static function hasBrokenColors(Registration $registration)
    {

        $animals = Animal::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->get();

        foreach ($animals as $animal) {
            if (self::colorBroken($animal)) return true;
        }

        $animals = AnimalPair::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->get();

        foreach ($animals as $animal) {
            if (self::colorBroken($animal)) return true;
        }

        $animals = AnimalAviary::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->get();

        foreach ($animals as $animal) {
            if (self::colorBroken($animal)) return true;
        }

        return false;
    }


    public static function colorBroken($animal)
    {
        return (Breed::find($animal->breedId)->breedNo != Color::find($animal->colorId)->breedNo);
    }

}