<?php

namespace App\Http\Controllers\Api;

use App\Animal;
use App\AnimalAviary;
use App\AnimalPair;
use App\Championship;
use App\ChampionshipParticipation;
use App\Exhibition;
use App\Exhibitor;
use App\Helper\PriceHelper;
use App\Http\Controllers\Controller;
use App\Http\Resources\RegistrationResource;
use App\Registration;
use Chumper\Zipper\Zipper;
use Illuminate\Http\Request;

class RegistrationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection|\Illuminate\Http\Response
     */
    public function index()
    {
        return RegistrationResource::collection(Registration::all());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $registration = Registration::find($id);

        $exhibition = Exhibition::find($registration->exhibitionId);
        $exhibitor = Exhibitor::find($registration->exhibitorId);


        $animals = Animal::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();
        $animalPairs = AnimalPair::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();
        $animalAviaries = AnimalAviary::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();


        $championships = Championship::where('exhibitionId', $exhibition->id)->get();
        $championShipParticipations = ChampionshipParticipation::where('exhibitorId', $exhibitor->id)
            ->where('exhibitionId', $exhibition->id)->get();

        $championShipFee = 0;

        foreach ($championships as $championship) {

            if ($championship->fee != 0) {
                $championShipFee += ChampionshipParticipation::where('exhibitorId', $exhibitor->id)
                        ->where('exhibitionId', $exhibition->id)
                        ->where('championshipId', $championship->id)
                        ->count() * $championship->fee;
            }
        }


        $context = [
            "registration" => $registration->only('locked', 'amount_special', 'amount_specialBonus', 'amount_prize', 'created_at'),

            "animals" => $animals->map(function ($animal) {
                return $animal->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice", 'animalName']);
            }),
            "animalPairs" => $animalPairs->map(function ($animal) {
                return $animal
                    ->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice", 'animalName']);
            }),
            "animalAviaries" => $animalAviaries->map(function ($animal) {
                return $animal->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice", 'animalName']);

            }),

            "exhibitor" => $exhibitor,
            "exhibition" => $exhibition,
            "championShipFee" => $championShipFee,

            "championShipParticipation" => $championShipParticipations->map(function ($item) {
                return [$item['championShipId'] => $item['animalKey']];
            }),


            "count" => ["priceCatalog" => (int)!($registration->judge or $exhibitor->type != 1),
                "priceSpecial" => $registration->amount_special,
                "pricePrize" => $registration->amount_prize,
                "priceSpecialBonus" => $registration->amount_specialBonus,

                "priceAviaries" => $animalAviaries->count(),
                "pricePairs" => $animalPairs->count(),
                "priceSingle" => $animals->count(),
                "priceSingle" => $exhibitor->type == 1 ? $animals->count() : 0,
                "priceSingleJunior" => $exhibitor->type == 2 ? $animals->count() : 0,
                "priceNewBreed" => 0]];


        return Response()->json(['data' => $context, "status" => 200]);


    }


    public function indexShowZipped(Exhibition $exhibition)
    {

        return response()->streamDownload(function () use ($exhibition) {

            $zipper = new Zipper();

            $zipper->make('storage/api/download.zip');


            $zipper->folder($exhibition->name);

            $registrations = Registration::where("exhibitionId", "=", $exhibition->id)->get();


            foreach ($registrations as $registration) {

                $exhibitor = Exhibitor::find($registration->exhibitorId);

                $animals = Animal::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();
                $animalPairs = AnimalPair::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();
                $animalAviaries = AnimalAviary::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();

                $championships = Championship::where('exhibitionId', $exhibition->id)->get();

                $championShipFee = 0;

                foreach ($championships as $championship) {
                    if ($championship->fee != 0) {
                        $championShipFee += ChampionshipParticipation::where('exhibitorId', $exhibitor->id)
                                ->where('exhibitionId', $exhibition->id)
                                ->where('championshipId', $championship->id)
                                ->count() * $championship->fee;
                    }
                }

                $championShipParticipations = ChampionshipParticipation::where('exhibitorId', $exhibitor->id)
                    ->where('exhibitionId', $exhibition->id)->get();

                $context = [
                    "registration" => $registration->only('locked', 'amount_special', 'amount_specialBonus', 'amount_prize', 'created_at','send_at'),

                    "animals" => $animals->map(function ($animal) {
                        return $animal->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice", 'animalName']);
                    }),
                    "animalPairs" => $animalPairs->map(function ($animal) {
                        return $animal->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice", 'animalName']);
                    }),
                    "animalAviaries" => $animalAviaries->map(function ($animal) {
                        return $animal->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice", 'animalName']);
                    }),

                    "exhibitor" => $exhibitor,
                    "exhibition" => $exhibition,

                    "championships" => $championships->map(function ($championship) {
                        return $championship->only(['id', 'name']);
                    }),

                    "championShipParticipation" => $championShipParticipations->mapToGroups(function ($item) {
                        return [$item['championshipId'] => $item['animalKey']];
                    }),

                    "championShipFee" => $championShipFee,


                    "count" => [
                        "priceCatalog" => (int)!($registration->judge or $exhibitor->type != 1),
                        "priceSpecial" => $registration->amount_special,
                        "pricePrize" => $registration->amount_prize,
                        "priceSpecialBonus" => $registration->amount_specialBonus,

                        "priceAviaries" => $animalAviaries->count(),

                        "pricePairs" => $animalPairs->count(),

                        "priceSingle" => $exhibitor->type == 1 ? $animals->count() : 0,
                        "priceSingleJunior" => $exhibitor->type == 2 ? $animals->count() : 0,

                        "priceNewBreed" => 0

                    ],


                ];

                $total = 0;
                $total += $championShipFee;
                foreach (PriceHelper::getPrices() as $label => $price) {
                    if ($exhibition->{$price} > 0 && ($context['count'][$price] ?? 1)) {
                        $total += $exhibition->$price * ($context['count'][$price] ?? 1);
                    }
                }

                $context['totalFee'] = $total;


                $zipper->addString('registration_' . $registration->id . '.json', json_encode(['data' => $context, "status" => 200]));
            }


            $zipper->close();

            echo file_get_contents('storage/api/download.zip');

            $zipper->make('storage/api/download.zip')->delete();


        }, $this->slugify($exhibition->name) . ".zip");


    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public
    function update(Request $request, $id)
    {

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     * @return \Illuminate\Http\Response
     */
    public
    function destroy($id)
    {
        //
    }

    private
    function slugify($string, $replace = array(), $delimiter = '-')
    {
        // https://github.com/phalcon/incubator/blob/master/Library/Phalcon/Utils/Slug.php
        if (!extension_loaded('iconv')) {
            throw new Exception('iconv module not loaded');
        }
        // Save the old locale and set the new locale to UTF-8
        $oldLocale = setlocale(LC_ALL, '0');
        setlocale(LC_ALL, 'en_US.UTF-8');
        $clean = iconv('UTF-8', 'ASCII//TRANSLIT', $string);
        if (!empty($replace)) {
            $clean = str_replace((array)$replace, ' ', $clean);
        }
        $clean = preg_replace("/[^a-zA-Z0-9\/_|+ -]/", '', $clean);
        $clean = strtolower($clean);
        $clean = preg_replace("/[\/_|+ -]+/", $delimiter, $clean);
        $clean = trim($clean, $delimiter);
        // Revert back to the old locale
        setlocale(LC_ALL, $oldLocale);
        return $clean;
    }
}
