<?php

namespace App\Console\Commands;

use App\Breed;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;

class importbreeds extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:breeds {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import Breeds';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws \Illuminate\Contracts\Filesystem\FileNotFoundException
     */
    public function handle()
    {

        if ($this->option('force')) {
            Breed::truncate();
        }

        $file     = Storage::get('Rassen.txt');
        $all_data = array();

        $lines = explode(PHP_EOL, $file);

        $total = count($lines);
        foreach ($lines as $k => $v) {
            if ($v === '') continue;

            $data = str_getcsv($v, ";");

            $breed = Breed::updateOrCreate(['groupNo' => (string)$data[0], 'breedNo'=> (string) $data[1]], ['breedName' => $data[2]]);
            $this->info('[' . sprintf('%05d', $k+1) . '/' . sprintf('%05d', $total) . ']' . ' Updated or Inserted ' . $breed->breedName);
        }

        $this->warn('Rassen.txt done');
    }
}
