@extends('layouts.app')
@section('content')

    <div class="uk-container">


        @if(\App\Exhibitor::where('userId',Auth::user()->id)->get()->count() == 0 )
            <div class="uk-alert uk-alert-info">
                <span uk-icon="icon: info"></span>
                Sie haben noch keinen Aussteller angelegt. <a href="{{route('exhibitor.create')}}">Klicken Sie hier um einen Aussteller anzulegen.</a>
            </div>
        @endif



        <div class="uk-card uk-card-default uk-card-body">
            <div class="uk-card-title">{{__('Anstehende Schauen')}}</div>

            <table class="uk-table uk-table-small uk-table-divider uk-first-column-bold">
                <tr>
                    <th width="20%"></th>
                    <th width="7%"></th>
                    <th width="">{{__("Datum")}}</th>
                    <th width="15%">{{__("Ort")}}</th>
                    <th width="25%">{{__("Anmeldungen")}}</th>
                    <th width="10%"></th>
                    <th>@if(Auth::user()->isAdmin)<a href="/exhibition/create" class="uk-icon-button uk-button-primary"><span uk-icon="icon:plus"></span></a>@endif</th>
                </tr>
                @each('exhibition.partials.row_index',$exhibitions,'exhibition')
            </table>
        </div>
    </div>

@endsection