@extends('layouts.app')

@section('content')
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-9">
                <div class="card">
                    <div class="card-header">Persönliche Daten</div>

                    <div class="card-body">
                        @if (session('status'))
                            <div class="alert alert-success">
                                {{ session('status') }}
                            </div>
                        @endif

                        <form class="form" action="/profile/{{ Auth::id() }}" method="post">
                            @csrf
                            @method('put')
                            <div class="form-group row">
                                <label for="inputFirstName" class="col-md-2 col-form-label">Name</label>
                                <div class="col-md-5">
                                    <input type="text" class="form-control" id="inputFirstName" value="{{Auth::user()->firstName}}" name="firstName" placeholder="Vorname">
                                </div>
                                <div class="col-md-5">
                                    <input type="text" class="form-control" id="inputLastName"  value="{{Auth::user()->lastName}}"name="lastName" placeholder="Nachname">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputPassword" class="col-md-2 col-form-label">Anschrift</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" id="inputAddress" name="address" value="{{Auth::user()->address}}"
                                           placeholder="Straße und Hausnummer">
                                </div>
                                <div class="col-sm-2 offset-2">
                                    <input type="text" class="form-control" id="inputZip" name="zip" value="{{Auth::user()->zip}}"
                                           placeholder="Postleitzahl">
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control" id="inputCity" name="city" value="{{Auth::user()->city}}"
                                           placeholder="Ort">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inputPhone" class="col-md-2 col-form-label">Telefon</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" id="inputPhone" name="telephone" value="{{Auth::user()->telephone}}"
                                           placeholder="Telefonnummer">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="inputBankname" class="col-md-2 col-form-label">Bank</label>
                                <div class="col-md-10 ">
                                    <input type="text" class="form-control" id="inputBankname" name="bankAccountOwner" value="{{Auth::user()->bankAccountOwner}}"
                                           placeholder="Konotinhaber">
                                </div>
                                <div class="col-md-10 offset-2">
                                    <input type="text" class="form-control" id="inputBankname" name="bankName" value="{{Auth::user()->bankName}}"
                                           placeholder="Bankname">
                                </div>
                                <div class="col-md-10 offset-2">
                                    <input type="text" class="form-control" id="inputIBAN" name="iban" value="{{Auth::user()->iban}}"
                                           placeholder="IBAN">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="inputRegNo" class="col-md-2 col-form-label">Registernr.</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" id="inputRegNo" name="regno" value="{{Auth::user()->regno}}"
                                           placeholder="Registernummer">
                                </div>
                            </div>

                            <div class="form-group row">
                                <label for="inputVetNo" class="col-md-2 col-form-label">Veterinäramt</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" id="inputVetNo" name="vet" value="{{Auth::user()->vet}}"
                                           placeholder="Veterinäramt">
                                </div>
                            </div>


                            <div class="form-group row">
                                <label for="inputVerein" class="col-md-2 col-form-label">Verein</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" id="inputVerein" name="society" value="{{Auth::user()->society}}"
                                           placeholder="Verein">
                                </div>
                            </div>

                            <button type="submit" class="btn btn-raised btn-primary">Speichern</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    </div>
@endsection
