<?php

namespace App\Console\Commands;

use App\Color;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;

class importcolors extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:colors {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import Colorings';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws \Illuminate\Contracts\Filesystem\FileNotFoundException
     */
    public function handle()
    {

        if ($this->option('force')) {
            Color::truncate();
        }

        $file     = Storage::get('Farben.txt');
        $all_data = array();

        $lines = explode(PHP_EOL, $file);

        $total = count($lines);

        foreach ($lines as $k => $v) {
            if ($v === '') continue;

            $data = str_getcsv($v, ";");

            $color = Color::updateOrCreate(['groupNo' => (string)$data[0], 'breedNo'=> (string) $data[1],'colorNo'=> (string) $data[2]], ['colorName' => $data[3]]);
            $this->info('[' . sprintf('%05d', $k+1) . '/' . sprintf('%05d', $total) . ']' . ' Updated or Inserted ' . $color->colorName);
        }


        $this->warn('Rassen.txt done');
    }
}
