<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class AddBankInfoToExhibition extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('exhibitions', function (Blueprint $table) {
            $table->text('bank_usage')->after('registrationEnd')->nullable();
            $table->text('bank_iban')->after('registrationEnd')->nullable();
            $table->text('bank_name')->after('registrationEnd')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('exhibitions', function (Blueprint $table) {
            $table->removeColumn('bank_usage');
            $table->removeColumn('bank_iban');
            $table->removeColumn('bank_name');
        });
    }
}
