<?php

namespace App\Http\Controllers;

use App\Championship;
use App\Exhibition;
use App\Helper\PriceHelper;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ExhibitionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $exhibitions = Exhibition::where("registrationEnd",">=",Carbon::now())->get();
        $pastExhibitions = Exhibition::where("registrationEnd","<",Carbon::now())->get();
        $registrations = [];

        return view('exhibition.index', compact('exhibitions', 'registrations','pastExhibitions'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $prices = PriceHelper::getPrices();

//        return view('exhibition.create.new', compact("prices"));
        return view('exhibition.create', compact("prices"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {



        $exhibition = new Exhibition();
        foreach ($request->except(['_token', '_method', 'exhibitorType', 'championShip','terms','logo','registrationEnd']) as $k => $v) {
            $exhibition->$k = $v ?? 0;
        }

        $exhibition->registrationEnd = Carbon::parse($request->registrationEnd)->endOfDay();



        $exhibition->save();


        if($request->file('terms'))
        {
            $file = $request->file('terms');

            Storage::disk('public')->putFileAs('exhibition/'.$exhibition->id, $file,$file->getClientOriginalName());

            $exhibition->terms = $file->getClientOriginalName();

        }



        if($request->file('logo'))
        {
            $file = $request->file('logo');
            Storage::disk('public')->putFileAs('exhibition/'.$exhibition->id, $file,$file->getClientOriginalName());;

            $exhibition->logo = $file->getClientOriginalName();
        }


        $exhibition->save();

        foreach ($request->championShip as $k => $v) {
            if($v['name'] == '') continue;


            if(isset($v['auto']) && $v['auto'] == "on") $v['auto'] = 1;
            else $v['auto'] = 0;

            $cs = new Championship($v);

            $cs->exhibitionId = $exhibition->id;
            $cs->save();
        }

        return redirect()->action('ExhibitionController@index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
