<?php
/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 03.12.18
 * Time: 11:53
 */

namespace App\Http\Controllers\Api;


use App\Animal;
use App\AnimalAviary;
use App\AnimalPair;
use App\Exhibition;

class ExhibitionController
{
    public
    function stats(Exhibition $exhibition)
    {
        $animals = Animal::where('exhibitionId', $exhibition->id)->get();
        $animalPairs = AnimalPair::where('exhibitionId', $exhibition->id)->get();
        $animalAviaries = AnimalAviary::where('exhibitionId', $exhibition->id)->get();


        $context = [
            "name" => $exhibition->name,
            "animals" => $animals->count(),
            "animalPairs" => $animalPairs->count(),
            "animalAviaries" => $animalPairs->count(),
            "registrations" => \App\Registration::where('exhibitionId',$exhibition->id)->get()->count(),
            "registrationsLocked" => \App\Registration::where('exhibitionId',$exhibition->id)->where('locked',1)->get()->count(),
        ];


        return Response()->json(['data' => $context, "status" => 200]);


    }
}