@extends('layouts.app')

@section('content')

    <div class="uk-container">
        <div class="uk-card uk-card-default uk-width-3-4@m uk-align-center">
            <div class="uk-card-header">
                <div class="uk-card-title">Neue Schau anlegen</div>
            </div>

            <div class="uk-card-body">
                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @endif

                <form action="/exhibition" method="post" class="uk-form-horizontal" enctype="multipart/form-data">
                    @csrf

                    <div class="uk-margin">
                        <label for="inputFirstName" class="uk-form-label">Name</label>
                        <div class="uk-form-controls">
                            <input type="text" class="uk-input" id="inputFirstName"
                                   value="{{$exhibition->name ?? ''}}" name="name"
                                   placeholder="Name">
                        </div>

                    </div>
                    <div class="uk-margin">
                        <label for="inputLocation" class="uk-form-label">Ort</label>
                        <div class="uk-form-controls">

                            <input type="text" class="uk-input" id="inputLocation"
                                   value="{{$exhibition->location ?? ''}}" name="location"
                                   placeholder="Ort">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="inputStartDate" class="uk-form-label">Beginnt am</label>
                        <div class="uk-form-controls">

                            <input type="date" class="uk-input" id="inputStartDate"
                                   value="{{$exhibition->startDate ?? ''}}" name="startDate"
                                   placeholder="Datum">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="inputEndDate" class="uk-form-label">Endet am</label>
                        <div class="uk-form-controls">

                            <input type="date" class="uk-input" id="inputEndDate"
                                   value="{{$exhibition->endDate ?? ''}}" name="endDate"
                                   placeholder="Datum">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="inputregEndDate" class="uk-form-label">Meldeschluss</label>
                        <div class="uk-form-controls">

                            <input type="date" class="uk-input" id="inputregEndDate"
                                   value="{{$exhibition->registrationEnd ?? ''}}" name="registrationEnd"
                                   placeholder="Datum">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="terms" class="uk-form-label">Ausstellungsbestimmungen</label>
                        <div class="uk-form-controls">
                               <input type="file" name="terms" id="terms">
                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="logo" class="uk-form-label">Logo</label>
                        <div class="uk-form-controls">

                            <input type="file"
                                   value="{{$exhibition->logo ?? ''}}" name="logo">

                        </div>
                    </div>


                    @foreach($prices as $label=>$price)
                        <div class="uk-margin">
                            <label for="input{{$price}}" class="uk-form-label">{{$label}}</label>
                            <div class="uk-form-controls">
                                <input type="number" class="uk-input" id="input{{$price}}"
                                       value="{{$exhibition->$price ?? ''}}"
                                       name="{{$price}}"
                                       step='0.50'
                                       placeholder="">
                            </div>
                        </div>
                    @endforeach



                    @for($i = 1; $i <= 6; $i++)
                        <div class="uk-margin">
                            <label for="inputChampionShip{{$i}}" class="uk-form-label">Meisterschaft #{{$i}}</label>
                            <div class="uk-form-controls">
                                <input type="text" class="uk-input" id="inputChampionShip{{$i}}"
                                       value="{{$exhibition->$price ?? ''}}"
                                       name="championShip[{{$i}}][name]"
                                >
                                <label><input type="checkbox" class="uk-checkbox" name="championShip[{{$i}}][auto]"
                                              value="1"> automatische Teilnahme</label>
                            </div>
                        </div>
                    @endfor

                    <button type="submit" class="uk-button-primary uk-button">Speichern</button>
                </form>
            </div>
        </div>
    </div>
@endsection

