<?php

namespace App\Helper;

use App\Breed;
use App\Color;
use App\Exhibitor;
use App\Registration;
use http\Env\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;

/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 29.05.18
 * Time: 16:31
 */
class RegistrationHelper
{

    public static function getRegistrationsFromUser($exhibitionId)
    {
        $user = Auth::user();

        $registrations = Registration::where('userId', $user->id)->where('exhibitionId', $exhibitionId)->get();

        return View::make('exhibition.partials.list_registrations', compact('registrations'))->render();
    }


    public static function getNonRegisterExhibitorsForExhibition($exhibtionId)
    {
        $exhibitors = Exhibitor::where('userId', Auth::id())->get();
        $registrations = Registration::where('userId', Auth::id())->where('exhibitionId', $exhibtionId)->get();


        foreach ($registrations as $key => $reg) {
            foreach ($exhibitors as $ekey => $exhib) {
                if ($reg->exhibitorId == $exhib->id) {
                    $exhibitors->forget($ekey);
                }
            }
        }
        return $exhibitors;
    }

    public static function getChampionshipCount($animals)
    {
        $championship = [];

        foreach ($animals as $animal) {
            $animalColor = Color::find($animal->color);
            $championship[] = implode(':', [$animalColor->groupNo, $animalColor->breedNo, $animalColor->colorNo]);
        }

        return count(array_unique($championship));
    }

    public static function getSelect2Breeds($last_breed = null )
    {
        $breeds = Breed::orderBy('id', 'asc')->get();


        foreach ($breeds as $breed) {
            $array = ["text" => $breed->breedName, "value" => $breed->groupNo . ':' . $breed->breedNo, 'id' => $breed->id];

            if ($breed->id == $last_breed) {
                $array['selected'] = true;
            }

            $breed_options[] = $array;
        }

        return $breed_options;
    }

    public static function getSelect2Colors($last_color = null)
    {
        $colors = Color::orderBy('id', 'asc')->get();


        $color_options = [];
        foreach ($colors as $color) {
            if (!isset($color_options[$color->groupNo . ":" . $color->breedNo])) $color_options[$color->groupNo . ":" . $color->breedNo] = [];

            $array = ["text" => $color->colorName, "value" => $color->colorNo, 'id' => $color->id];

            if ($color->id == $last_color) {
                $array['selected'] = 1;
            }

            $color_options[$color->groupNo . ":" . $color->breedNo][] = $array;
        }

        return $color_options;
    }


}