<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Exhibitor
 *
 * @package App
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property int $userId
 * @property string|null $firstName
 * @property string|null $lastName
 * @property string|null $address
 * @property string|null $zip
 * @property string|null $city
 * @property string|null $telephone
 * @property string|null $bankName
 * @property string|null $bankAccountOwner
 * @property string|null $iban
 * @property string|null $regno
 * @property string|null $vet
 * @property string|null $society
 * @property int|null $type
 * @property int $isJudge
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereAddress($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereBankAccountOwner($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereBankName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereCity($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereFirstName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereIban($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereIsJudge($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereLastName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereRegno($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereSociety($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereTelephone($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereType($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereUpdatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereUserId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereVet($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Exhibitor whereZip($value)
 */
class Exhibitor extends Model
{
    /**
     * @var array
     */
    protected $fillable = [
        "firstName",
        "lastName",
        "address",
        "zip",
        "city",
        "telephone",
        "bankName",
        "bankAccountOwner",
        "iban",
        "regno",
        "vet",
        "society",
    ];


    /**
     * @return string
     */
    public function getFullname()
    {
        return $this->firstName.' '.$this->lastName;
    }
}
