<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class BreedGroup
 *
 * @package App
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property string $groupNo
 * @property string $groupName
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\BreedGroup whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\BreedGroup whereGroupName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\BreedGroup whereGroupNo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\BreedGroup whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\BreedGroup whereUpdatedAt($value)
 */
class BreedGroup extends Model
{
    /**
     * @var array
     */
    protected $fillable = [
        'groupNo',
        'groupName'
    ];
}
