@extends('layouts.app')

@section('content')

    <div class="uk-container">

        <div class="uk-card uk-card-default uk-width-2-3@m uk-align-center">

            <div class="uk-card-header">
                <div class="uk-card-title">{{ __('auth.register_headline') }}
                </div>
            </div>

            <div class=" uk-card-body ">
                <form class="uk-form-horizontal" method="POST" action="{{ route('register') }}">
                    @csrf


                    <div class="uk-margin">
                        <label for="email"
                               class="uk-form-label">{{ __('auth.emailaddress') }}</label>

                        <div class="uk-form-controls">
                            <input id="email" type="email"
                                   class="uk-input{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email"
                                   value="{{ old('email') }}" required>

                            @if ($errors->has('email'))
                                <span class="invalid-feedback">
                                        <strong>{{ $errors->first('email') }}</strong>
                                    </span>
                            @endif
                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="password" class="uk-form-label">{{ __('auth.password') }}</label>

                        <div class="uk-form-controls">
                            <input id="password" type="password"
                                   class="uk-input{{ $errors->has('password') ? ' is-invalid' : '' }}"
                                   name="password"
                                   required>

                            @if ($errors->has('password'))
                                <span class="invalid-feedback">
                                        <strong>{{ $errors->first('auth.password') }}</strong>
                                    </span>
                            @endif
                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="password-confirm"
                               class="uk-form-label">{{ __('auth.password confirm') }}</label>

                        <div class="uk-form-controls">
                            <input id="password-confirm" type="password" class="uk-input"
                                   name="password_confirmation"
                                   required>
                        </div>
                    </div>

                    <div class="uk-margin mb-0">
                        <div class="uk-form-controls offset-md-4">
                            <button type="submit" class="uk-button uk-button-primary">
                                {{ __('auth.register') }}
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

@endsection
