<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Breed
 *
 * @package App
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property string $groupNo
 * @property string $breedNo
 * @property string $breedName
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Breed whereBreedName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Breed whereBreedNo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Breed whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Breed whereGroupNo($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Breed whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\Breed whereUpdatedAt($value)
 */
class Breed extends Model
{
    protected $fillable = [
        'groupNo',
        'breedNo',
        'breedName'
    ];   //
}
