<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    if (Auth::guest()) return view('welcome');
    else return redirect('home');
});

Route::get('/impressum', function (){
    return view('service.imprint');
})->name('imprint');

Route::get('/datenschutz', function (){
    return view('service.data-protection');
})->name('dataprotection');

Auth::routes();



Route::group(['middleware'=>"auth"],function(){

    Route::get('/home', 'HomeController@index')->name('home');


    Route::resource('/profile','UserProfileController');
    Route::resource('/anmeldung','RegistrationController');
    Route::get('/anmeldung/{registration}/send','RegistrationController@send');


    Route::resource('/animal/single','AnimalController');
    Route::get('/animal/single/{single}/delete', 'AnimalController@destroy');

    Route::resource('/animal/pairs','AnimalPairController');
    Route::get('/animal/pairs/{pair}/delete', 'AnimalPairController@destroy');

    Route::resource('/animal/aviary','AnimalAviaryController');
    Route::get('/animal/aviary/{aviary}/delete', 'AnimalAviaryController@destroy');


    Route::resource('/support','SupportController');




    Route::resource('/exhibitor','ExhibitorController');
    Route::resource('/exhibition','ExhibitionController');

    Route::resource('/championship','ChampionshipController');

    Route::get('/anmeldung/create/{exhibition}','RegistrationController@create');
    Route::get('/exhibitor/{id}/setdefault','ExhibitorController@setDefault');

});

#Route::get('/profile','UserProfileController@edit');
