<?php

namespace App\Http\Controllers\Api;

use App\Animal;
use App\AnimalAviary;
use App\AnimalPair;
use App\Championship;
use App\Exhibition;
use App\Exhibitor;
use App\Http\Resources\RegistrationResource;
use App\Registration;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Response;

class RegistrationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Resources\Json\AnonymousResourceCollection|\Illuminate\Http\Response
     */
    public function index()
    {
        return RegistrationResource::collection(Registration::all());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $registration = Registration::find($id);

        $exhibition = Exhibition::find($registration->exhibitionId);
        $exhibitor = Exhibitor::find($registration->exhibitorId);


        $animals = Animal::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();
        $animalPairs = AnimalPair::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();
        $animalAviaries = AnimalAviary::where('exhibitionId', $registration->exhibitionId)->where('exhibitorId', $registration->exhibitorId)->orderBy('id', 'asc')->get();


        $championships = Championship::where('exhibitionId', $exhibition->id)->get();


        $championShipFee = 0;

        foreach ($championships as $championship) {

            if ($championship->fee != 0) {
                $championShipFee += ChampionshipParticipation::where('exhibitorId', $exhibitor->id)
                        ->where('exhibitionId', $exhibition->id)
                        ->where('championshipId', $championship->id)
                        ->count() * $championship->fee;
            }
        }


        $context = [
            "registration" => $registration->only('locked', 'amount_special', 'amount_specialBonus', 'amount_prize', 'created_at'),

            "animals" => $animals->map(function ($animal) {
                return $animal->only(['animalKey',"aocColor", "gender_age", "ownBreeding", "sellprice"]);
            }),
            "animalPairs" => $animalPairs->map(function ($animal) {
                return $animal
                    ->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice"]);
            }),
            "animalAviaries" => $animalAviaries->map(function ($animal) {
                return $animal->only(['animalKey', "aocColor", "gender_age", "ownBreeding", "sellprice"]);

            }),

            "exhibitor" => $exhibitor->only('userId'),
            "exhibition" => $exhibition,
            "championShipFee" => $championShipFee,


            "count" => [
                "priceCatalog" => (int)!($registration->judge or $exhibitor->type != 1),
                "priceSpecial" => $registration->amount_special,
                "pricePrize" => $registration->amount_prize,
                "priceSpecialBonus" => $registration->amount_specialBonus,

                "priceAviaries" => $animalAviaries->count(),
                "pricePairs" => $animalPairs->count(),
                "priceSingle" => $animals->count(),
                "priceNewBreed" => 0
            ]
        ];


        return Response()->json(['data' => $context, "status" => 200]);


    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
