@extends('layouts.app')

@section('content')

    <div class="uk-container">
        <div class="uk-card uk-card-default uk-width-3-4@m uk-align-center">
            <div class="uk-card-header">
                <div class="uk-card-title">Neue Schau anlegen</div>
            </div>

            <div class="uk-card-body">
                @if (session('status'))
                    <div class="alert alert-success">
                        {{ session('status') }}
                    </div>
                @endif

                <form action="/exhibition" method="post" class="uk-form-horizontal">
                    @csrf

                    <div class="uk-margin">
                        <label for="inputFirstName" class="uk-form-label">Name</label>
                        <div class="uk-form-controls">
                            <input type="text" class="uk-input" id="inputFirstName"
                                   value="{{$exhibition->name ?? ''}}" name="name"
                                   placeholder="Name">
                        </div>

                    </div>
                    <div class="uk-margin">
                        <label for="inputLocation" class="uk-form-label">Ort</label>
                        <div class="uk-form-controls">

                            <input type="text" class="uk-input" id="inputLocation"
                                   value="{{$exhibition->location ?? ''}}" name="location"
                                   placeholder="Ort">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="inputStartDate" class="uk-form-label">Beginnt am</label>
                        <div class="uk-form-controls">

                            <input type="date" class="uk-input" id="inputStartDate"
                                   value="{{$exhibition->startDate ?? ''}}" name="startDate"
                                   placeholder="Datum">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="inputEndDate" class="uk-form-label">Endet am</label>
                        <div class="uk-form-controls">

                            <input type="date" class="uk-input" id="inputEndDate"
                                   value="{{$exhibition->endDate ?? ''}}" name="endDate"
                                   placeholder="Datum">

                        </div>
                    </div>

                    <div class="uk-margin">
                        <label for="inputregEndDate" class="uk-form-label">Meldeschluss</label>
                        <div class="uk-form-controls">

                            <input type="date" class="uk-input" id="inputregEndDate"
                                   value="{{$exhibition->registrationEnd ?? ''}}" name="registrationEnd"
                                   placeholder="Datum">

                        </div>
                    </div>


                    @foreach($prices as $label=>$price)
                        <div class="uk-margin">
                            <label for="input{{$price}}" class="uk-form-label">{{$label}}</label>
                            <div class="uk-form-controls">
                                <input type="number" class="uk-input" id="input{{$price}}"
                                       value="{{$exhibition->$price ?? ''}}"
                                       name="{{$price}}"
                                       step='0.50'
                                       placeholder="">
                            </div>
                        </div>
                    @endforeach



                    @for($i = 1; $i <= 6; $i++)
                        <div class="uk-margin">
                            <label for="inputChampionShip{{$i}}" class="uk-form-label">Meisterschaft #{{$i}}</label>
                            <div class="uk-form-controls">
                                <input type="text" class="uk-input" id="inputChampionShip{{$i}}"
                                       value="{{$exhibition->$price ?? ''}}"
                                       name="championShip[{{$i}}][name]"
                                    >
                            </div>
                        </div>
                        @endfor

                    <button type="submit" class="uk-button-primary uk-button">Speichern</button>
                </form>
            </div>
        </div>
    </div>
@endsection

