<?php

namespace App\Http\Controllers;

use App\Championship;
use App\Exhibition;
use App\Helper\PriceHelper;
use Illuminate\Http\Request;

class ExhibitionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $exhibitions = Exhibition::all();
        return view('exhibition.index', compact('exhibitions', 'registrations'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $prices = PriceHelper::getPrices();

        return view('exhibition.create', compact("prices"));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $exhibition = new Exhibition();
        foreach ($request->all() as $k => $v) {
            if (in_array($k, ['_token', '_method', 'exhibitorType', 'championShip'])) {
                continue;
            }
            $exhibition->$k = $v ?? 0;
        }
        $exhibition->save();

        foreach ($request->championShip as $k => $v) {
            if($v['name'] != '') continue;

            $cs = new Championship($v);
            $cs->exhibitionId = $exhibition->id;
            $cs->save();
        }

        return redirect()->action('ExhibitionController@index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
