<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class AnimalAviary
 *
 * @package App
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @property int $id
 * @property int $exhibitorId
 * @property int $exhibitionId
 * @property int $breedId
 * @property int $colorId
 * @property int $sellprice
 * @property int $championship
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereBreedId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereChampionship($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereColorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereExhibitionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereExhibitorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereSellprice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalAviary whereUpdatedAt($value)
 */
class AnimalAviary extends Model
{
    protected $fillable = [
        'sellprice',
        'exhibitorId',
        'exhibitionId',
        'colorId',
        'breedId'
    ];
}
