<?php

namespace App\Helper;

use App\Color;
use App\Exhibitor;
use App\Registration;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\View;

/**
 * Created by PhpStorm.
 * User: jfschubert
 * Date: 29.05.18
 * Time: 16:31
 */
class RegistrationHelper
{

    public static function getRegistrationsFromUser($exhibitionId)
    {
        $user = Auth::user();


        $registrations = Registration::where('userId', $user->id)->where('exhibitionId', $exhibitionId)->get();

        return View::make('exhibition.partials.list_registrations', compact('registrations'))->render();
    }


    public static function getNonRegisterExhibitorsForExhibition($exhibtionId)
    {
        $exhibitors    = Exhibitor::where('userId', Auth::id())->get();
        $registrations = Registration::where('userId', Auth::id())->where('exhibitionId', $exhibtionId)->get();


        foreach ($registrations as $key => $reg) {
            foreach ($exhibitors as $ekey => $exhib) {
                if ($reg->exhibitorId == $exhib->id) {
                    $exhibitors->forget($ekey);
                }
            }
        }

        return $exhibitors;

    }

    public static function getChampionshipCount($animals)
    {
        $championship = [];

        foreach ($animals as $animal) {
            $animalColor    = Color::find($animal->color);
            $championship[] = implode(':', [$animalColor->groupNo, $animalColor->breedNo, $animalColor->colorNo]);
        }

        return count(array_unique($championship));
    }


}