<?php

namespace App\Notifications;

use App\Exhibition;
use App\Exhibitor;
use App\Registration;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class RegistrationComplete extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Registration $registration)
    {
        $this->registration = $registration;
        $this->exhibitor = Exhibitor::find($registration->exhibitorId);
        $this->exhibition = Exhibition::find($registration->exhibitionId);



    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {

        $subject = 'amadeus Onlinemeldebogen | '.$this->exhibitor->firstName.' '.$this->exhibitor->lastName;
        $subject .= ' | '.$this->exhibition->name;

        return (new MailMessage)
                    ->subject($subject)
                    ->greeting('Hallo '.$this->exhibitor->firstName.' '.$this->exhibitor->lastName)
                    ->line('Wir haben ihren Meldebogen erhalten.')
                    ->line(' Bitte senden Sie keinen Meldebogen mehr via Post')
                    ->action('Ihren Meldebogen ansehen', url('/anmeldung/'.$this->registration->id))
                    ->line('Vielen Dank')
                    ->salutation('amadeus Verlag');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
