<tr>
    <td>{{$exhibition->name}}</td>
    <td>
        @if($exhibition->logo !== null and Storage::disk('public')->exists('exhibition/'.$exhibition->id.DIRECTORY_SEPARATOR.$exhibition->logo))
            <img width="100%"
                 src="{{Storage::disk('public')->url('exhibition/'.$exhibition->id.DIRECTORY_SEPARATOR.$exhibition->logo)}}">
        @endif
    </td>

    <td>{{\Carbon\Carbon::parse($exhibition->startDate)->format('d.m')}}
        - {{\Carbon\Carbon::parse($exhibition->endDate)->format('d.m.Y')}}<br/>
        <small>Meldeschluss: {{\Carbon\Carbon::parse($exhibition->registrationEnd)->format('d.m.Y')}}</small>
    </td>
    <td>{{$exhibition->location}}</td>
    <td>{!! \App\Helper\RegistrationHelper::getRegistrationsFromUser($exhibition->id) !!}</td>
    <td>
        @if(\Carbon\Carbon::now()->gte( \Carbon\Carbon::parse($exhibition->registrationEnd)->addDays(1) ))
            <small>{{__("Meldeschluss")}}</small>
        @elseif(\App\Helper\RegistrationHelper::getNonRegisterExhibitorsForExhibition($exhibition->id)->count() > 0)
            <a href="/anmeldung/create/{{$exhibition->id}}"
               class="btn btn-raised btn-primary pull-md-right">Anmelden</a>
        @else
            <small>{{__("Ihre Aussteller sind bereits angemeldet")}}</small>
        @endif

    </td>
    @if(Auth::user()->isAdmin)
        <td>
            <small><a href="/api/exhibition/{{$exhibition->id}}/zip"
                      class="uk-icon-button" uk-tooltip="Anmeldungen als .zip-Datei herunterladen"><span
                            uk-icon="icon:download"></span></a>
            </small>
            <small><a href="/registrations/exhibition/{{$exhibition->id}}/list"
                      class="uk-icon-button" uk-tooltip="Alle Anmeldungen anzeigen"><span
                            uk-icon="icon: list"></span></a>
            </small>
        </td>
    @endif
</tr>