<?php

namespace App\Http\Controllers;

use App\Championship;
use App\ChampionshipParticipation;
use Illuminate\Http\Request;

class ChampionshipController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Championship $Championship
     * @return \Illuminate\Http\Response
     */
    public function show(Championship $Championship)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Championship $Championship
     * @return \Illuminate\Http\Response
     */
    public function edit(Championship $Championship)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  \App\Championship $Championship
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Championship $Championship)
    {


        $colors = [];

        foreach ($request->except(['_token', '_method', 'exhibitorId']) as $k => $v) {
            if (in_array($k, ['_token', '_method', 'exhibitorId'])) {
                continue;
            }

            $colors[] = (int)str_replace("color_", "", $k);
        }


        $participations = ChampionshipParticipation::where('exhibitorId', $request->exhibitorId)->where('championshipId', $Championship->id)->get();

        foreach ($participations as $participation) {
            echo $participation->colorId;
            if (in_array($participation->colorId, $colors)) {
                $colors = array_diff($colors, [$participation->colorId]);
                var_dump($colors);
            } else $participation->delete();
        }

        foreach ($colors as $color) {
            $participation = new ChampionshipParticipation();
            $participation->colorId = $color;
            $participation->championshipId = $Championship->id;
            $participation->exhibitorId = $request->exhibitorId;
            $participation->exhibitionId = $Championship->exhibitionId;
            $participation->save();
        }


        return back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Championship $Championship
     * @return \Illuminate\Http\Response
     */
    public function destroy(Championship $Championship)
    {
        //
    }
}
