@extends('layouts.app')
@section('content')

    <div class="uk-container">


        <div class="uk-card uk-card-default">
            <div class="uk-card-header">Zur {{$exhibition->name}} anmelden</div>
            <div class="uk-card-body">
                <h2>Möchten Sie sich zur {{ $exhibition->name }} anmelden ?</h2><br/>

                <div class="uk-grid.small" uk-grid>
                    <div class="uk-width-1-1">
                        <form method="post" action="/anmeldung" class="uk-form-horizontal">
                            @csrf

                            @include('globals.partials.error')

                            <input type="hidden" name="exhibition" value="{{$exhibition->id}}">
                            <div class="uk-margin">
                                <label for="exhibitor" class="uk-form-label">Annmelden als</label>
                                <div class="uk-form-controls">
                                    <select class="uk-select" name="exhibitor" id="exhibitor">
                                        @each('registration.partials.exhibitor_options',$exhibitors,'exhibitor');
                                    </select>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <div class="uk-form-controls">
                                    <input type="checkbox" class="uk-checkbox" name="judge"> Der Aussteller ist Preisrichter auf dieser Schau
                                </div>
                            </div>
                            <div class="uk-margin">
                                <div class="uk-form-controls">
                                    <input type="checkbox" class="uk-checkbox" required> Der Aussteller stimmt der Ausstellungsordnung zu
                                </div>
                            </div>
                            <div class="uk-margin">
                                <div class="uk-form-controls">
                                    <input type="submit" class="uk-button-primary uk-button "
                                           value="Verbindlich anmelden">
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="uk-width-1-2@m">
                        @include('registration.partials.pricingtable')
                    </div>
                    <div class="uk-width-1-2@m">
                        <a href="{{asset(('storage/app/public/Ausstellungsordnung.pdf'))}}"><span class="uk-icon" uk-icon="download"></span>&nbsp;Ausstellungsordnung herunterladen</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    </div>

@endsection