@extends('layouts.app')

@section('content')

    <div class="uk-container">
        <div class="uk-grid">
            <div class="uk-width-3-4@m">
                <h2> Aussteller auswählen</h2>
                <p>{{trans_choice("exhibitor.max_exhibitors",Auth::user()->maxExhibitors,["value" => Auth::user()->maxExhibitors])}} <br/>
                    <small>Falls Sie mehr Austeller benötigen oder eine anderweitige Frage an das Meldebogen-Team haben verwenden Sie bitte unser <a hreF="{{route('support.index')}}">Kontaktformular</a>.</small>
                </p>
                @if(Auth::user()->maxExhibitors > $exhibitors->count()  or Auth::user()->isAdmin)
                    <a class="uk-button uk-button-primary" href="/exhibitor/create" ><span uk-icon="icon: plus"></span>&nbsp;Aussteller hinzufügen</a>
                @endif()
            </div>
            <div class="uk-width-1-4@m">
                <a class="uk-button uk-button-primary" href="/exhibition"> Zu den Ausstellungen</a>
            </div>
        </div>
        <hr>
        <div class="card-deck" uk-grid>
            @isset($exhibitors)
                @each('exhibitor.cards',$exhibitors,'exhibitor')
            @endisset
        </div>
    </div>

@endsection
