@extends('layouts.app')
@section('content')


    <div class="uk-container">
        <div class="uk-grid">
            <div class="uk-width-1-5">
                <div class="uk-card uk-card-small uk-card-default">
                    <h5 class="uk-card-header"><a href="/admin/user">Benutzer</a></h5>
                    <div class="uk-card-body">
                        {{ \App\User::all()->count() }}
                    </div>
                </div>
            </div>

            <div class="uk-width-1-5">
                <div class="uk-card uk-card-small uk-card-default">
                    <h5 class="uk-card-header">Aussteller</h5>
                    <div class="uk-card-body">
                        {{ \App\Exhibitor::all()->count() }}
                        ( {{  number_format(\App\Exhibitor::all()->count()/ \App\User::all()->count(),2) }} pro User )
                    </div>
                </div>
            </div>

            <div class="uk-width-1-5">
                <div class="uk-card uk-card-small uk-card-default">
                    <h5 class="uk-card-header">Ausstellungen</h5>
                    <div class="uk-card-body">
                        {{ \App\Exhibition::all()->count() }}
                    </div>
                </div>
            </div>

            <div class="uk-width-1-5">
                <div class="uk-card uk-card-small uk-card-default">
                    <h5 class="uk-card-header">Anmeldungen gesamt</h5>
                    <div class="uk-card-body">
                        {{ \App\Registration::all()->count() }}
                    </div>
                </div>
            </div>

            <div class="uk-width-1-5">
                <div class="uk-card uk-card-small uk-card-default">
                    <h5 class="uk-card-header">Tiere gesamt
                        <small>(E | SP | V)</small>
                    </h5>
                    <div class="uk-card-body">
                        {{ \App\Animal::all()->count() }} | {{ \App\AnimalPair::all()->count() }}
                        | {{ \App\AnimalAviary::all()->count() }}
                    </div>
                </div>
            </div>
        </div>

        <div class="uk-grid">
            <div class="uk-width-1-1">
                <div class="uk-card uk-card-small uk-card-default">
                    <h5 class="uk-card-header">Ausstellungübersicht</h5>


                    <table class="uk-table uk-table-divider uk-table-striped">
                        <tr>
                            <th>Name</th>
                            <th colspan="2">Anmeldungen</th>
                            <th colspan="4">Tiere</th>
                        </tr>
                        <tr>
                            <th></th>
                            <th>angemeldet</th>
                            <th>abgeschickt</th>

                            <th>gesamt</th>
                            <th>Einzeltiere</th>
                            <th>Paare / Stämme</th>
                            <th>Volieren</th>


                        </tr>


                        @foreach(\App\Exhibition::all() as $exhib)

                            <tr>
                                <td>{{$exhib->name}}</td>

                                <td>{{\App\Registration::where('exhibitionId',$exhib->id)->get()->count()}}</td>
                                <td>{{\App\Registration::where('exhibitionId',$exhib->id)->where('locked',"1")->get()->count()}}</td>
                                <td>
                                    {{\App\Animal::where('exhibitionId',$exhib->id)->get()->count()
                                    + \App\AnimalPair::where('exhibitionId',$exhib->id)->get()->count()
                                    + \App\AnimalAviary::where('exhibitionId',$exhib->id)->get()->count()}}
                                </td>
                                <td>{{\App\Animal::where('exhibitionId',$exhib->id)->get()->count()}}</td>
                                <td>{{\App\AnimalPair::where('exhibitionId',$exhib->id)->get()->count()}}</td>
                                <td>{{\App\AnimalAviary::where('exhibitionId',$exhib->id)->get()->count()}}</td>

                            </tr>


                        @endforeach
                    </table>
                </div>
            </div>
        </div>


    </div>



@endsection