<?php


namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;

class MeldebogenSupportRequest extends Mailable
{
    use Queueable, SerializesModels;

    public string $nachricht;
    public string $sender;
    private string $mail_subject;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct($subject, $nachricht, $sender)
    {
        $this->mail_subject = $subject;
        $this->nachricht = $nachricht;
        $this->sender = $sender;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Builds mail content
     *
     * @return $this
     */
    public function build() {
        return $this->from('meldebogen@amadeus-verlag.net')
                    ->subject('Meldebogen Support Request | ' . $this->mail_subject)
                    ->replyTo($this->sender)
                    ->view('mail.support_plain')
                    ->text('mail.support_plain');
    }
}