<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * App\ChampionshipParticipation
 *
 * @property int $id
 * @property int $exhibitionId
 * @property int $exhibitorId
 * @property int $championshipId
 * @property string $colorId
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereChampionshipId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereColorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereExhibitionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereExhibitorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\ChampionshipParticipation whereUpdatedAt($value)
 * @mixin \Eloquent
 */
class ChampionshipParticipation extends Model
{
    protected function getAnimalKeyAttribute()
    {
        $c = Color::find($this->colorId);

        return implode(':',[$c->groupNo,$c->breedNo,$c->colorNo]);
    }
}
