@extends('layouts.app')
@section('content')

    <div class="uk-container">

        <div class="uk-card uk-card-default ">

            <div class="uk-card-header">
                <div class="uk-card-title">Tier bearbeiten</div>
            </div>
            <form class="uk-form-horizontal uk-card-body" method="POST" action="/animal/{{$type}}/{{$animal->id}}">

                <div class="uk-margin">
                    <label class="uk-form-label" for="">Rasse</label>
                    <div class="uk-form-controls">
                        <select class="select2 selectBreed" placeholder="Rasse wählen">
                            <option></option>
                        </select>
                    </div>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label" for="">Farbe</label>
                    <div class="uk-form-controls">
                        <select class="select2 selectColor" placeholder="Farbe wählen">
                        </select>
                    </div>
                </div>

                @if($type == "single")
                    <div class="uk-margin">
                        <label class="uk-form-label" for="form-horizontal-text">Geschlecht / Alter</label>
                        <div class="uk-form-controls">
                            <label><input class="uk-radio" type="radio" name="genderAge" value="10j"
                                          {{$animal->gender_age == "10j" ? "checked" : ''}} required>&nbsp;10j&nbsp;</label>
                            <label><input class="uk-radio" type="radio" name="genderAge" value="10a"
                                          {{$animal->gender_age == "10a" ? "checked" : ''}} required>&nbsp;10a&nbsp;</label>
                            <label><input class="uk-radio" type="radio" name="genderAge" value="01j"
                                          {{$animal->gender_age == "01j" ? "checked" : ''}} required>&nbsp;01j&nbsp;</label>
                            <label><input class="uk-radio" type="radio" name="genderAge" value="01a"
                                          {{$animal->gender_age == "01a" ? "checked" : ''}} required>&nbsp;01a&nbsp;</label>
                        </div>
                    </div>
                @endif

                <div class="uk-margin">
                    <label class="uk-form-label" for="form-horizontal-text">Verkaufspreis</label>
                    <div class="uk-form-controls">
                        <input class="uk-input uk-form-small" type="number" name="sellPrice"
                               value="{{$animal->sellprice}}">
                    </div>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label" for="form-horizontal-text"></label>
                    <div class="uk-form-controls">
                        <label><input class="uk-checkbox" type="checkbox"
                                      name="ownBreeding" {{$animal->ownBreeding ? "checked" : ''}}> Eigene Zucht
                        </label>
                    </div>
                </div>

                <div class="uk-margin">
                    <label class="uk-form-label" for="form-horizontal-text">AOC Farbe</label>
                    <div class="uk-form-controls">
                        <input type="text" class="uk-input" name="aocColor" value="{{$animal->aocColor}}">
                    </div>
                </div>


                <div class="uk-card-footer">
                    <input type="hidden" name="breed">
                    <input type="hidden" name="color">
                    @method('put')
                    @csrf()
                    <input type="submit" class="uk-button uk-button-primary" value="Speichern">
                </div>
            </form>
        </div>


    </div>

@endsection


@push('js-data')
    var breeds = @json($breed_options);
    var colors = @json($color_options);
    var lastBreed = @json($animal->breedId);
    var lastColor = @json($animal->colorId);
    var edit = true;

@endpush