<?php

namespace App\Notifications;

use App\Animal;
use App\AnimalAviary;
use App\AnimalPair;
use App\Championship;
use App\ChampionshipParticipation;
use App\Exhibition;
use App\Exhibitor;
use App\Helper\RegistrationHelper;
use App\Registration;
use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class MeldebogenComplete extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    public function __construct(Registration $registration)
    {
        $this->registration = $registration;
        $this->exhibitor = Exhibitor::find($registration->exhibitorId);
        $this->exhibition = Exhibition::find($registration->exhibitionId);
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        $subject = ($this->registration->locked ? 'Meldebogen geändert' : 'Meldebogen erhalten');
        $subject .= ' | ' . $this->exhibitor->getFullname();
        $subject .= ' | ' . $this->exhibition->name;


        $animals = Animal::where('exhibitionId', $this->registration->exhibitionId)->where('exhibitorId', $this->registration->exhibitorId)->orderBy('id', 'asc')->get();
        $animalPairs = AnimalPair::where('exhibitionId', $this->registration->exhibitionId)->where('exhibitorId', $this->registration->exhibitorId)->orderBy('id', 'asc')->get();
        $animalAviaries = AnimalAviary::where('exhibitionId', $this->registration->exhibitionId)->where('exhibitorId', $this->registration->exhibitorId)->orderBy('id', 'asc')->get();


        $championships = Championship::where('exhibitionId', $this->exhibition->id)->get();


        $championShipFee = 0;

        foreach ($championships as $championship) {

            if ($championship->fee != 0) {
                
                $championShipFee += ChampionshipParticipation::where('exhibitorId', $this->exhibitor->id)
                        ->where('exhibitionId', $this->exhibition->id)
                        ->where('championshipId',$championship->id)
                        ->count()*$championship->fee;
            }
        }


        $context = [
            "registration" => $this->registration,

            "animals" => $animals,
            "animalPairs" => $animalPairs,
            "animalAviaries" => $animalAviaries,

            "exhibitorName" => $this->exhibitor->getFullname(),
            "exhibitor" => $this->exhibitor,
            "exhibition" => $this->exhibition,
            "championShipFee" => $championShipFee,

            "url" => env('APP_URL') . '/anmeldung/' . $this->registration->id,

            "count" => [
                "priceCatalog" => !($this->registration->judge or $this->exhibitor->type != 1),
                "priceSpecial" => $this->registration->amount_special,
                "pricePrize" => $this->registration->amount_prize,
                "priceSpecialBonus" => $this->registration->amount_specialBonus,

                "priceAviaries" => $animalAviaries->count(),
                "pricePairs" => $animalPairs->count(),
                "priceSingle" => $animals->count(),
                "priceNewBreed" => 0
            ]
        ];

        return (new MailMessage)->subject($subject)->markdown('mail.registration.complete', $context);
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
