<?php

namespace App\Http\Controllers;

use App\AnimalPair;
use App\Helper\RegistrationHelper;
use App\Registration;
use Illuminate\Http\Request;

class AnimalPairController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $animalPair = new AnimalPair();


        $animalPair->sellprice = $request->sellPrice ?? 0;
        $animalPair->exhibitionId = $request->exhibition;
        $animalPair->exhibitorId = $request->exhibitor;
        $animalPair->colorId = $request->color;
        $animalPair->breedId = $request->breed;
        $animalPair->championship = $request->championship == 'on' ? 1 : 0;
        $animalPair->aocColor = $request->aocColor ?? '';
        $animalPair->ownBreeding = $request->ownBreeding == 'on' ? 1 : 0;

        $animalPair->save();

        $request->session()->put('last_breed', $request->breed);
        $request->session()->put('last_color', $request->color);

        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param AnimalPair $pair
     * @return void
     */
    public function show(AnimalPair $pair)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param AnimalPair $pair
     * @return void
     */
    public function edit(AnimalPair $pair)
    {

        $breed_options = RegistrationHelper::getSelect2Breeds($pair->breedId);
        $color_options = RegistrationHelper::getSelect2Colors($pair->colorId);
        $type = "pairs";
        $animal = $pair;


        $context = compact("animal", "breed_options", "color_options", "type");


        return view('animals.edit', $context);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param AnimalPair $pair
     * @return void
     */
    public function update(Request $request, AnimalPair $pair)
    {
        $animal = $pair;

        $animal->sellprice = $request->sellPrice ?? 0;
        $animal->colorId = $request->color;
        $animal->breedId = $request->breed;
        $animal->championship = $request->championship == 'on' ? 1 : 0;
        $animal->aocColor = $request->aocColor ?? '';
        $animal->ownBreeding = $request->ownBreeding == 'on' ? 1 : 0;

        $animal->save();

        $registration = Registration::where('exhibitionId', $animal->exhibitionId)->where('exhibitorId', $animal->exhibitorId)->first();

        return redirect()->action('RegistrationController@show', [$registration]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param AnimalPair $pair
     * @return void
     * @throws \Exception
     */
    public function destroy(AnimalPair $pair)
    {

        $pair->delete();
        return redirect()->back();
    }
}
