@extends('layouts.app')

@section('content')
    <div class="uk-container">
        <div class="row justify-content-center">
            <div class="col-md-9">
                <div class="uk-card uk-card-default">
                    <div class="uk-card-header">{{__("Neuer Aussteller")}}</div>
                    <form class="uk-form-horizontal" action="/exhibitor" method="post">
                        <div class="uk-card-body">
                            @if (session('status'))
                                <div class="alert alert-success">
                                    {{ session('status') }}
                                </div>
                            @endif
                            <div class="uk-margin">
                                <label for="inputFirstName" class="uk-form-label">{{__("Name")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-2">
                                        <input type="text" class="uk-input" id="inputFirstName"
                                               value="{{$exhibitor->firstName ?? ''}}" name="firstName"
                                               placeholder="{{__("Vorname")}}"
                                               required>
                                    </div>
                                    <div class="uk-width-1-2">
                                        <input type="text" class="uk-input" id="inputLastName"
                                               value="{{$exhibitor->lastName ?? ''}}" name="lastName" required
                                               placeholder="{{__("Nachname")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputPassword" class="uk-form-label">{{__("Anschrift")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputAddress" name="address" required
                                               value="{{$exhibitor->address ?? ''}}"
                                               placeholder="{{__("Straße und Hausnummer")}}">
                                    </div>
                                    <div class="uk-width-1-4">
                                        <input type="text" class="uk-input" id="inputZip" name="zip" required
                                               value="{{$exhibitor->zip ?? ''}}"
                                               placeholder="{{__("Postleitzahl")}}">
                                    </div>
                                    <div class="uk-width-3-4">
                                        <input type="text" class="uk-input" id="inputCity" name="city" required
                                               value="{{$exhibitor->city ?? ''}}"
                                               placeholder="{{__("Ort")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputPhone" class="uk-form-label">{{__("Telefon")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputPhone" name="telephone" required
                                               value="{{$exhibitor->telephone?? ''}}"
                                               placeholder="{{__("Telefonnummer")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputBankname" class="uk-form-label">{{__("Bank")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-1 ">
                                        <input type="text" class="uk-input" id="inputBankname" name="bankAccountOwner"
                                               value="{{$exhibitor->bankAccountOwner ?? ''}}"
                                               placeholder="{{__("Konotinhaber (falls Abweichend)")}}">
                                    </div>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputBankname" name="bankName"
                                               value="{{$exhibitor->bankName ?? ''}}"
                                               placeholder="{{__("Bankname")}}">
                                    </div>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputIBAN" name="iban"
                                               value="{{$exhibitor->iban ?? ''}}"
                                               placeholder="{{__("IBAN")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">

                                <label for="inputRegNo" class="uk-form-label">{{__("Registriernr.")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputRegNo" name="regno" required
                                               value="{{$exhibitor->regno ?? ''}}"
                                               placeholder="{{__("Veterinär-Registriernummer")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputVetNo" class="uk-form-label">{{__("Veterinäramt")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputVetNo" name="vet"
                                               value="{{$exhibitor->vet ?? ''}}"
                                               placeholder="{{__("Veterinäramt")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="inputVerein" class="uk-form-label">{{__("Verein")}}</label>
                                <div class="uk-form-controls uk-grid-small" uk-grid>
                                    <div class="uk-width-1-1">
                                        <input type="text" class="uk-input" id="inputVerein" name="society" required
                                               value="{{$exhibitor->society ?? ''}}"
                                               placeholder="{{__("Verein")}}">
                                    </div>
                                </div>
                            </div>
                            <div class="uk-margin">
                                <label for="" class="uk-form-label">{{__("Aussteller/in")}}</label>
                                <div class="uk-form-controls uk-margin uk-grid-small uk-child-width-auto uk-grid">

                                    <div class="">
                                        <label for="inlineRadio1">
                                            <input type="radio" name="exhibitorType" id="inlineRadio1" value="1"
                                                   class="uk-radio"
                                                   required>
                                            {{__("Senior")}}
                                        </label>
                                    </div>
                                    <div class="">
                                        <label for="inlineRadio2">
                                            <input type="radio" name="exhibitorType" id="inlineRadio2" value="2"
                                                   class="uk-radio"
                                                   required>
                                            {{__("Jugendlicher")}}
                                        </label>
                                    </div>

                                </div>
                            </div>
                        </div>

                        <div class="uk-card-footer">
                            @csrf
                            <button type="submit" class="uk-button uk-button-primary uk-float-right"><span
                                        uk-icon="plus"></span>
                                &nbsp;{{__("Speichern")}}
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

