<?php

namespace App\Http\Controllers;

use App\Animal;
use App\Breed;
use App\Color;
use App\Helper\RegistrationHelper;
use App\Registration;
use Illuminate\Http\Request;

class AnimalController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        for ($i = 1; $i <= $request->amount; $i++) {
            $animal = new Animal();

            $animal->gender_age = $request->genderAge;
            $animal->sellprice = $request->sellPrice ?? 0;
            $animal->exhibitionId = $request->exhibition;
            $animal->exhibitorId = $request->exhibitor;
            $animal->colorId = $request->color;
            $animal->breedId = $request->breed;
            $animal->championship = $request->championship == 'on' ? 1 : 0;
            $animal->aocColor = $request->aocColor ?? '';
            $animal->ownBreeding = $request->ownBreeding == 'on' ? 1 : 0;

            $animal->save();

        }


        $request->session()->put('last_breed', $request->breed);
        $request->session()->put('last_color', $request->color);
        $request->session()->put('last_position', "singleAnimalAddRow");


        return redirect()->back();

    }

    /**
     * Display the specified resource.
     *
     * @param Animal $single
     * @return void
     */
    public function show(Animal $single)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param Animal $single
     * @return void
     */
    public function edit(Animal $single)
    {

        $breed_options = RegistrationHelper::getSelect2Breeds($single->breedId);
        $color_options = RegistrationHelper::getSelect2Colors($single->colorId);
        $type = "single";
        $animal = $single;

        $context = compact("animal", "breed_options", "color_options", "type");


        return view('animals.edit', $context);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param Animal $single
     * @return void
     */
    public function update(Request $request, Animal $single)
    {

        $animal = $single;

        $animal->gender_age = $request->genderAge;
        $animal->sellprice = $request->sellPrice ?? 0;
        $animal->colorId = $request->color;
        $animal->breedId = $request->breed;
        $animal->championship = $request->championship == 'on' ? 1 : 0;
        $animal->aocColor = $request->aocColor ?? '';
        $animal->ownBreeding = $request->ownBreeding == 'on' ? 1 : 0;

        $animal->save();


        $registration = Registration::where('exhibitionId', $animal->exhibitionId)->where('exhibitorId', $animal->exhibitorId)->first();


        return redirect()->action('RegistrationController@show', [$registration]);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param Animal $single
     * @return \Illuminate\Http\Response
     * @throws \Exception
     */
    public function destroy(Animal $single)
    {


        $single->delete();
        return redirect()->back();
    }
}
