<?php

namespace App\Console\Commands;

use App\BreedGroup;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Storage;

class importgroups extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'import:groups {--force}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Import BreedGroups';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     * @throws \Illuminate\Contracts\Filesystem\FileNotFoundException
     */
    public function handle()
    {
        if ($this->option('force')) {
            BreedGroup::truncate();
        }

        $file     = Storage::get('Gruppen.txt');
        $all_data = array();

        $lines = explode(PHP_EOL, $file);

        $total = count($lines);
        foreach ($lines as $k => $v) {
            if ($v === '') continue;

            $data = str_getcsv($v, ";");

            $breedGroup = BreedGroup::updateOrCreate(['groupNo' => (string)$data[0]], ['groupName' => $data[1]]);
            $this->info('[' . sprintf('%05d', $k+1) . '/' . sprintf('%05d', $total) . ']' . ' Updated or Inserted ' . $breedGroup->groupName);
        }

        $this->warn('Gruppen.txt done');

    }
}
