<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

/**
 * Class AnimalPair
 *
 * @mixin \Eloquent
 * @mixin \Illuminate\Database\Eloquent\Builder
 * @package App
 * @property int $id
 * @property int $exhibitorId
 * @property int $exhibitionId
 * @property int $breedId
 * @property int $colorId
 * @property int $sellprice
 * @property int $championship
 * @property \Carbon\Carbon|null $created_at
 * @property \Carbon\Carbon|null $updated_at
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereBreedId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereChampionship($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereColorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereExhibitionId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereExhibitorId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereSellprice($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereUpdatedAt($value)
 * @property int $ownBreeding
 * @property string|null $aocColor
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereAocColor($value)
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereOwnBreeding($value)
 * @property int $breedRegistry
 * @method static \Illuminate\Database\Eloquent\Builder|\App\AnimalPair whereBreedRegistry($value)
 */
class AnimalPair extends Model
{
    protected $fillable = [
        'sellprice',
        'exhibitorId',
        'exhibitionId',
        'colorId',
        'breedId'
    ];

    protected function getAnimalKeyAttribute()
    {
        $c = Color::find($this->colorId);

        return implode(':',[$c->groupNo,$c->breedNo,$c->colorNo]);
    }

}
