import * as Popper from '@popperjs/core';
import Modal from 'bootstrap/js/src/modal';
import Tooltip from 'bootstrap/js/src/tooltip';
import Collapse from 'bootstrap/js/src/collapse';
import Dropdown from 'bootstrap/js/src/dropdown';
import Popover from 'bootstrap/js/src/popover';


var dropdownElementList = [].slice.call(document.querySelectorAll('.dropdown-toggle'))
var dropdownList = dropdownElementList.map(function (dropdownToggleEl) {
    return new Dropdown(dropdownToggleEl)
})

var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
    return new Tooltip(tooltipTriggerEl)
})


var popoverTriggerList = [].slice.call(document.querySelectorAll('.ce-cooperation_partner'))
var popoverList = popoverTriggerList.map(function (popoverTriggerEl) {
    return new Popover(popoverTriggerEl, {
        // template: '<div class="popover" role="tooltip"><div class="popover-arrow"></div><div class="popover-inner"><h3 class="popover-header"></h3><div class="popover-body"></div></div></div>',
        html: true,
        trigger: 'focus hover',
        placement: 'auto',
        fallbackPlacements: ['right', 'left', 'bottom', 'top'],
        offset: [0, 0]
    })
})

//
// var myNodeList = document.querySelectorAll("[data-bs-toggle='flyout']");
// [].forEach.call(myNodeList, function (element) {
//     element.addEventListener('mouseover', function (e) {
//         console.log(this.parentNode);
//         this.parentNode.classList.toggle("open");
//         e.stopPropagation();
//     });
//     element.addEventListener('mouseout', function (e) {
//         console.log(this.parentNode);
//         this.parentNode.classList.toggle("open");
//         e.stopPropagation();
//     });
// });


