@setup
$path = '/www/htdocs/w0153c6b/';
$projectFolder = 'mein-amadeus.de/';
$projectPath = $path.$projectFolder;
$branch = 'dev-2017';

@endsetup

@servers(['dev' => 'ssh-w0153c6b@w0145ef0.kasserver.com'])

@task('test')
cd {{ $projectPath }}
ls -l
@endtask

@task('freshdeploy')
cd {{$path}}

rm -rf {{$projectFolder}}
mkdir -p {{$projectFolder}} && cd {{$projectFolder}}


echo "Cloning Repository"
git clone --branch {{ $branch }} --single-branch git@gitlab.com:amadeus-agentur/amadeus-verlag.git .

echo "Getting Composer.phar"
[ ! -f composer.phar ] && wget -o -q https://getcomposer.org/composer.phar
echo "Getting wp-cli.phar"
[ ! -f wp-cli.phar ] && wget -o -q https://raw.githubusercontent.com/wp-cli/builds/gh-pages/phar/wp-cli.phar

echo "Setting Permissions for composer and wp-cli.phar"

chmod +x ./composer.phar
chmod +x ./wp-cli.phar

echo "Running Composer Install"
/usr/bin/php70 ./composer.phar install

echo "Complete"

echo "PLEASE CREATE AN .env-FILE"


@endtask

@task('deploy')
cd {{$projectPath}}
git pull
/usr/bin/php70 ./composer.phar clearcache
/usr/bin/php70 ./composer.phar update
@endtask

@task('composer:install')
cd {{$projectPath}}
git pull
/usr/bin/php56 ./composer.phar install
@endtask

@task('composer:update')
cd {{$projectPath}}
git pull
/usr/bin/php56 ./composer.phar install
rm ./composer.lock
@endtask

@task('forcedeploy')
cd {{$projectPath}}
git fetch --all
git reset --hard origin/{{$branch}}
rm ./composer.lock

[ ! -f composer.phar ] && wget -o -q https://getcomposer.org/composer.phar

/usr/bin/php70 ./composer.phar clearcache
/usr/bin/php70 ./composer.phar update
@endtask