<?php

/* * *************************************************************
 *  Copyright notice
 *
 *  (c) 2010 LAMP solutions <noc@lamp-solutions.de>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 * ************************************************************* */
/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */
//require_once(PATH_tslib . 'class.tslib_pibase.php');

/**
 * Plugin 'PLZ-Suche' for the 'lamp_plz_suche' extension.
 *
 * @author	LAMP solutions <noc@lamp-solutions.de>
 * @package	TYPO3
 * @subpackage	tx_lampplzsuche
 */
class tx_lampplzsuche_pi1 extends TYPO3\CMS\Frontend\Plugin\AbstractPlugin {

  var $prefixId = 'tx_lampplzsuche_pi1';  // Same as class name
  var $scriptRelPath = 'pi1/class.tx_lampplzsuche_pi1.php'; // Path to this script relative to the extension dir.
  var $extKey = 'lamp_plz_suche'; // The extension key.
  var $pi_checkCHash = true;

  /**
   * The main method of the PlugIn
   *
   * @param	string		$content: The PlugIn content
   * @param	array		$conf: The PlugIn configuration
   * @return	The content that is displayed on the website
   */
  function main($content, $conf) {
    $this->conf = $conf;
    $this->pi_setPiVarDefaults();
    $this->pi_loadLL();

    //Template holen        
    $tmpl = $this->cObj->fileResource("fileadmin/templates/serag-wiessner/Extensions/suche_postleitzahl.html");
    //$tmpl = $this->cObj->fileResource("fileadmin/templates/seralea/Extensions/suche_postleitzahl.html");
    
    // Teilbereich auslesen
    $tmpl = $this->cObj->getSubpart($tmpl, "###PLZSUCHE###");
    $tmpl_kopf = $this->cObj->getSubpart($tmpl, "###PLZKOPF###");
    $tmpl_kopf2 = $this->cObj->getSubpart($tmpl, "###PLZKOPF2###");
    $tmpl_ausgabe = $this->cObj->getSubpart($tmpl, "###PLZAUSGABE###");
    $tmpl_ausgabe_innen = $this->cObj->getSubpart($tmpl, "###PLZAUSGABEINNEN###");
    $tmpl_ausgabe_fehler = $this->cObj->getSubpart($tmpl, "###FEHLER###");

    //Spalte definieren
    $spalte[1]["spalte"] = 'vrt_nm';
    $spalte[1]["name"]   = 'Nahtmaterial';
    $spalte[2]["spalte"] = 'vrt_impl';
    $spalte[2]["name"]   = 'Implantate';
    $spalte[3]["spalte"] = 'vrt_loes';
    $spalte[3]["name"]   = 'L&ouml;sungen';

    //Postleitzahl definieren
    $plz = intval($_POST["PLZ"]);
    if((strlen($plz) == 4) && (intval($plz) > 1000)) {
      $showplz = "0" . $plz;
    } else if(strlen($plz) == 5) {
      $showplz = $plz;
    } else {
      $showplz = '';
    }
    $marker["###SUCHEPLZ###"] = $showplz;
    $content.=$this->cObj->substituteMarkerArrayCached($tmpl_kopf, $marker);
    
    if(isset($_POST["bt_suche"])) {
      //Passenden Ort suchen
      $SQL = "SELECT  
                tx_lampplzsuche_gebiete.ort,
                tx_lampplzsuche_gebiete.bundesland
              FROM
                tx_lampplzsuche_gebiete
              WHERE
                CAST(tx_lampplzsuche_gebiete.plz AS unsigned)=" . $plz . "";
      $result = $GLOBALS['TYPO3_DB']->sql_query($SQL);
      if(mysqli_num_rows($result) > 0) {
        $row = mysqli_fetch_assoc($result);
        $marker["###SUCHEORT###"] = $row["ort"];
        $marker["###SUCHELAND###"] = $row["bundesland"];

        $content.=$this->cObj->substituteMarkerArrayCached($tmpl_kopf2, $marker);
        $i = 0;
        foreach ($spalte as $vertreter) {
          if($spalte[$i]["name"]!=="Nahtmaterial"){
            die ("TEst" );
            $i++;
            continue;
          }
          //marker leeren
          $marker["###ERGEBNISVORNAME###"] = '';
          $marker["###ERGEBNISNACHNAME###"] = '';
          $marker["###ERGEBNISSTRASSE###"] = '';
          $marker["###ERGEBNISPLZ###"] = '';
          $marker["###ERGEBNISORT###"] = '';
          $marker["###ERGEBNISTELEFON###"] = '';
          $marker["###ERGEBNISFAX###"] = '';
          $marker["###ERGEBNISMOBIL###"] = '';
          $marker["###ERGEBNISEMAIL###"] = '';
          $marker["###ERGEBNISURL###"] = '';
          $i++;
          
          $SQL = "SELECT  
                    tx_lampplzsuche_vertreter.vorname,
                    tx_lampplzsuche_vertreter.nachname,
                    tx_lampplzsuche_vertreter.strasse,
                    tx_lampplzsuche_vertreter.plz,
                    tx_lampplzsuche_vertreter.ort,
                    tx_lampplzsuche_vertreter.telefon,
                    tx_lampplzsuche_vertreter.fax,
                    tx_lampplzsuche_vertreter.mobil,
                    tx_lampplzsuche_vertreter.email,
                    tx_lampplzsuche_vertreter.url
                  FROM
                    tx_lampplzsuche_gebiete
                  INNER JOIN
                    tx_lampplzsuche_vertreter
                  ON  
                    tx_lampplzsuche_gebiete." . $spalte[$i]["spalte"] . " = tx_lampplzsuche_vertreter.kennung
                  WHERE
                    CAST(tx_lampplzsuche_gebiete.plz AS unsigned)=" . $plz . "";
          $result = $GLOBALS['TYPO3_DB']->sql_query($SQL);
          if(mysqli_num_rows($result) > 0) {
            $marker["###UEBERSCHRIFTBEREICH###"] = 'Ihr Ansprechpartner ' . $spalte[$i]["name"];
            while ($row = mysqli_fetch_assoc($result)) {

              $marker["###ERGEBNISVORNAME###"] = ($row["vorname"]);
              $marker["###ERGEBNISNACHNAME###"] = ($row["nachname"]);
              $marker["###ERGEBNISSTRASSE###"] = ($row["strasse"]);
              $marker["###ERGEBNISPLZ###"] = ($row["plz"]);
              $marker["###ERGEBNISORT###"] = ($row["ort"]);
              if ($row["telefon"] != '') {
                $marker["###ERGEBNISTELEFON###"] = '<span class="label">Telefon: </span>' . ($row["telefon"]) . '<br />';
              }
              if($row["fax"] != '') {
                $marker["###ERGEBNISFAX###"] = '<span class="label">Fax: </span>' . ($row["fax"]) . '<br />';
              }
              if($row["mobil"] != '') {
                $marker["###ERGEBNISMOBIL###"] = '<span class="label">Mobil: </span>' . ($row["mobil"]) . '<br />';
              }
              if($row["email"] != '') {
                $marker["###ERGEBNISEMAIL###"] = '<span class="label">E-Mail: </span>' . ($row["email"]) . '<br />';
              }
              if($row["url"] != '') {
                $marker["###ERGEBNISURL###"] = '<span class="label">URL: </span>' . ($row["url"]);
              }
            }
            $content_tmp.=$this->cObj->substituteMarkerArrayCached($tmpl_ausgabe_innen, $marker);
          }
        }
        $content.=$this->cObj->substituteSubpart($tmpl_ausgabe, "###PLZAUSGABEINNEN###", $content_tmp);
      } else {
        $content = $this->cObj->substituteMarkerArrayCached($tmpl_kopf, $marker);
        $content.= $this->cObj->substituteMarkerArrayCached($tmpl_ausgabe_fehler, $marker);
      }
    }
    return $this->pi_wrapInBaseClass($content);
  }

}

if (defined('TYPO3_MODE') && $TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/lamp_plz_suche/pi1/class.tx_lampplzsuche_pi1.php']) {
  include_once($TYPO3_CONF_VARS[TYPO3_MODE]['XCLASS']['ext/lamp_plz_suche/pi1/class.tx_lampplzsuche_pi1.php']);
}
