<?php
/***************************************************************
 *  Copyright notice
 *
 *  (c) 2010 LAMP solutions <noc@lamp-solutions.de>
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
use TYPO3\CMS\Backend\Utility\BackendUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/**
 * [CLASS/FUNCTION INDEX of SCRIPT]
 *
 * Hint: use extdeveval to insert/update function index above.
 */


$GLOBALS['LANG']->includeLLFile( 'EXT:lamp_plz_suche/mod1/locallang.xml' );
//require_once(PATH_t3lib . 'class.t3lib_scbase.php');
$GLOBALS['BE_USER']->modAccess( $MCONF, 1 );    // This checks permissions and exits if the users has no permission for entry.
// DEFAULT initialization of a module [END]


/**
 * Module 'import' for the 'lamp_plz_suche' extension.
 *
 * @author    LAMP solutions <noc@lamp-solutions.de>
 * @package    TYPO3
 * @subpackage    tx_lampplzsuche
 */
class  tx_lampplzsuche_module1 extends \TYPO3\CMS\Backend\Module\BaseScriptClass {
	var $pageinfo;

	/**
	 * Initializes the Module
	 * @return    void
	 */
	function init() {
		global $BE_USER, $LANG, $BACK_PATH, $TCA_DESCR, $TCA, $CLIENT, $TYPO3_CONF_VARS;

		parent::init();

		/*
		if (t3lib_div::_GP('clear_all_cache'))	{
			$this->include_once[] = PATH_t3lib.'class.t3lib_tcemain.php';
		}
		*/
	}

	/**
	 * Adds items to the ->MOD_MENU array. Used for the function menu selector.
	 *
	 * @return    void
	 */
	function menuConfig() {
		global $LANG;
		$this->MOD_MENU = Array(
			'function' => Array(
				'1' => $LANG->getLL( 'function1' ),
				#'2' => $LANG->getLL('function2'),
				#'3' => $LANG->getLL('function3'),
			)
		);
		parent::menuConfig();
	}

	/**
	 * Main function of the module. Write the content to $this->content
	 * If you chose "web" as main module, you will need to consider the $this->id parameter which will contain the uid-number of the page clicked in the page tree
	 *
	 * @return    [type]        ...
	 */
	function main() {
		global $BE_USER, $LANG, $BACK_PATH, $TCA_DESCR, $TCA, $CLIENT, $TYPO3_CONF_VARS;

		// Access check!
		// The page will show only if there is a valid page and if this page may be viewed by the user
		$this->pageinfo = BackendUtility::readPageAccess( $this->id, $this->perms_clause );
		$access         = is_array( $this->pageinfo ) ? 1 : 0;

		if ( ( $this->id && $access ) || ( $BE_USER->user['admin'] && ! $this->id ) ) {

			// Draw the header.
			$this->doc           = GeneralUtility::makeInstance( 'TYPO3\\CMS\\Backend\\Template\\DocumentTemplate' );
			$this->doc->backPath = $BACK_PATH;
			$this->doc->form     = '<form action="" method="post" enctype="multipart/form-data">';

			// JavaScript
			$this->doc->JScode   = '
							<script language="javascript" type="text/javascript">
								script_ended = 0;
								function jumpToUrl(URL)	{
									document.location = URL;
								}
							</script>
						';
			$this->doc->postCode = '
							<script language="javascript" type="text/javascript">
								script_ended = 1;
								if (top.fsMod) top.fsMod.recentIds["web"] = 0;
							</script>
						';

			$headerSection = $this->doc->getHeader( 'pages', $this->pageinfo, $this->pageinfo['_thePath'] ) . '<br />' . $LANG->sL( 'LLL:EXT:lang/locallang_core.xml:labels.path' ) . ': ' . GeneralUtility::fixed_lgd_cs( $this->pageinfo["_thePath"], - 50 );

			$this->content .= $this->doc->startPage( $LANG->getLL( 'title' ) );
			$this->content .= $this->doc->header( $LANG->getLL( 'title' ) );
			$this->content .= $this->doc->spacer( 5 );
			#$this->content.=$this->doc->section('',$this->doc->funcMenu($headerSection,t3lib_BEfunc::getFuncMenu($this->id,'SET[function]',$this->MOD_SETTINGS['function'],$this->MOD_MENU['function'])));
			$this->content .= $this->doc->divider( 5 );


			// Render content:
			$this->moduleContent();


			// ShortCut
			if ( $BE_USER->mayMakeShortcut() ) {
				$this->content .= $this->doc->spacer( 20 ) . $this->doc->section( '', $this->doc->makeShortcutIcon( 'id', implode( ',', array_keys( $this->MOD_MENU ) ), $this->MCONF['name'] ) );
			}

			$this->content .= $this->doc->spacer( 10 );
		} else {
			// If no access or if ID == zero

			$this->doc           = GeneralUtility::makeInstance( 'TYPO3\\CMS\\Backend\\Template\\DocumentTemplate' );
			$this->doc->backPath = $BACK_PATH;

			$this->content .= $this->doc->startPage( $LANG->getLL( 'title' ) );
			$this->content .= $this->doc->header( $LANG->getLL( 'title' ) );
			$this->content .= $this->doc->spacer( 5 );
			$this->content .= $this->doc->spacer( 10 );
		}

	}

	/**
	 * Prints out the module HTML
	 *
	 * @return    void
	 */
	function printContent() {

		$this->content .= $this->doc->endPage();
		echo $this->content;
	}

	/**
	 * Generates the module content
	 *
	 * @return    void
	 */
	function moduleContent() {
		switch ( (string) $this->MOD_SETTINGS['function'] ) {
			case 1:

				//importiert einen neue Postleitzahlen
				if ( $_FILES["uploadfile"]["name"] ) {

					//Dateiname bestimmen
					$filename = $_SERVER['DOCUMENT_ROOT'] . "uploads/benutzerdaten/" . $_FILES["uploadfile"]["name"];

					//Datei umbenennen
					if ( move_uploaded_file( $_FILES["uploadfile"]["tmp_name"], $filename ) ) {

						//+++++offen Back erstellen
						//...
						//++++++offen


						if ( $GLOBALS['TYPO3_DB']->sql_query( "TRUNCATE TABLE tx_lampplzsuche_gebiete" ) ) {
						} else {
							$content = "<div align=center><strong>Probleme beim l&ouml;schen der Daten: " . mysql_error() . "</div><br />";
						}

						//hier startet der eigentliche Import
						$filehandle = fopen( $filename, "r" );
						$zeile      = 0;
						while ( ! feof( $filehandle ) ) {
							$zeile ++;
							//Titelzeile interessiert uns nicht
							if ( $zeile > 1 ) {
								$records    = fgetcsv( $filehandle, 4096, ",", "\"" ); // Trenner , und "" um Felder
								$fieldcount = count( $records ) - 1;
								$SQL        = "INSERT into tx_lampplzsuche_gebiete(
                                                        pid,
                                                        plz,     
                                                        ort,     
                                                        bundesland,     
                                                        art_auslieferung,
                                                        vrt_nm,  
                                                        vrt_impl,
                                                        vrt_loes)
                                                    VALUES(
                                                        43,";
								for ( $a = 0; $a <= $fieldcount; $a ++ ) {
									$SQL .= "'" . $records[ $a ] . "'";
									if ( $a != $fieldcount ) {
										$SQL .= ", ";
									}
								}
								$SQL .= ")";
								if ( $fieldcount > 0 ) {
									if ( $GLOBALS['TYPO3_DB']->sql_query( $SQL ) ) {
									} else {
										$content .= '<pre>' . var_dump( $SQL ) . '</pre>';
										$content .= "<div align=center><strong>Probleme beim Import in Zeile " . $zeile . ": " . mysql_error() . "</div><br />";
									}
								}
							}
						}
						$content .= 'Upload erfolgreich';
						fclose( $filehandle );
						unlink( $filename );
					} else {
						$content = 'Konnte Datei ' . $filename . ' nicht anlegen';
					}
				}
				//Formularfeld ausgeben
				$content .= '<p><strong>CSV-Datei mit Postleitzahlen hochladen und Importieren:</strong><br>(Trenner , und "" um Felder)<br>';
				$content .= '<input type="file" name="uploadfile" /><br /><br />';
				$content .= '<input type="submit" name="importcsv" value="hochladen und importieren"></p>';

				$this->content .= $this->doc->section( 'Message #1:', $content, 0, 1 );
				break;
			case 2:
				$content = '<div align=center><strong>Menu item #2...</strong></div>';
				$this->content .= $this->doc->section( 'Message #2:', $content, 0, 1 );
				break;
			case 3:
				$content = '<div align=center><strong>Menu item #3...</strong></div>';
				$this->content .= $this->doc->section( 'Message #3:', $content, 0, 1 );
				break;
		}
	}

}


if ( defined( 'TYPO3_MODE' ) && $TYPO3_CONF_VARS[ TYPO3_MODE ]['XCLASS']['ext/lamp_plz_suche/mod1/index.php'] ) {
	include_once( $TYPO3_CONF_VARS[ TYPO3_MODE ]['XCLASS']['ext/lamp_plz_suche/mod1/index.php'] );
}


// Make instance:
$SOBE = GeneralUtility::makeInstance( 'tx_lampplzsuche_module1' );
$SOBE->init();

// Include files?
foreach ( $SOBE->include_once as $INC_FILE ) {
	include_once( $INC_FILE );
}

$SOBE->main();
$SOBE->printContent();

?>
