<?php

use Amadeus\Core\Shortcode as Shortcode;
use Timber\Menu as TimberMenu;
use Timber\Site as TimberSite;
use Timber\Timber;


if (!class_exists('Timber\Timber')) {
    add_action('admin_notices', function () {
        echo '<div class="error"><p>amadeus CORE not activated. Make sure you activate the plugin in <a href="' . esc_url(admin_url('plugins.php#timber')) . '">' . esc_url(admin_url('plugins.php')) . '</a></p></div>';
    });

    add_filter('template_include', function ($template) {
        return get_stylesheet_directory() . '/static/no-timber.html';
    });

    return;
}

Timber::$dirname = array('views');

function timber_set_product( $post ) {
    global $product;

    if ( is_woocommerce() ) {
        $product = wc_get_product( $post->ID );
    }
}

class DieKochLocationSite extends TimberSite
{

    protected $themeSlug = 'diekochlocation';
    protected $footerColumns = 5;

    function __construct()
    {
        add_theme_support('post-formats', array('aside', 'gallery', 'status', 'video'));
        add_theme_support('post-thumbnails');
        add_theme_support('menus');
        add_theme_support('automatic-feed-links');
        add_theme_support('html5', array('comment-list', 'comment-form', 'search-form', 'gallery', 'caption'));
        add_theme_support('title-tag');
        add_theme_support('customize-selective-refresh-widgets');
        add_theme_support('gutenberg');
        add_theme_support('woocommerce');

        add_filter('timber_context', array($this, 'addToContext'));

        add_action('widgets_init', [$this, 'registerWidgetAreas']);

        add_action('wp_enqueue_scripts', [$this, 'registerScripts'], 1, 1);
        add_action('wp_enqueue_scripts', [$this, 'registerStyles'], 2, 13);
        add_action('admin_enqueue_scripts', [$this, 'registerAdminScripts'], 999, 0);
        add_action('wp_enqueue_scripts', [$this, 'deregisterStyles'], 999, 0);
        add_action('login_enqueue_scripts', [$this, 'registerLoginStyles']);

        add_action('init', [$this, 'registerOnInit']);

        add_filter('amadeus_team_template', function ($template) {
            return 'shortcodes/team.twig';
        });

        add_filter('amadeus_team_queryargs', function ($args) {

            $modified_args = $args;

            $modified_args['meta_key'] = 'nachname';
            $modified_args['orderby'] = 'meta_value';
            $modified_args['order'] = 'ASC';

            return $modified_args;
        });

        $this->addUpdater();




        add_filter( 'woocommerce_enqueue_styles', '__return_empty_array' );

        remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail' );
        remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_product_data_tabs', 10);
        remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
        remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );

        parent::__construct();
    }

    function registerOnInit()
    {
        new Shortcode('product_marquee', [$this, 'renderProductMarquee']);
        new Shortcode('product_teaser', [$this, 'renderProductTeaser']);
    }


    function addToContext($context)
    {
        $context['site'] = $this;

        $context['primary'] = new TimberMenu('primary');
        $context['footer'] = new TimberMenu('footer');

        $context['footerAreas'] = [];
        for ($i = 1; $i <= $this->footerColumns; $i++) {
            $context['footerAreas'][] = Timber::get_widgets('footer-'.$i);
        }
        return $context;
    }

    function myfoo($text)
    {
        return $text;
    }

    function add_to_twig($twig)
    {
        /* this is where you can add your own functions to twig */
        $twig->addExtension(new Twig_Extension_StringLoader());

        return $twig;
    }

    function addUpdater()
    {

        $myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
            'https://updates.amadeus-agentur.com/?action=get_metadata&slug=' . $this->themeSlug,
            __FILE__, //Full path to the main plugin file or functions.php.
            $this->themeSlug
        );
    }

    public function registerAdminScripts()
    {
        wp_enqueue_style('z-amds-style', get_theme_root_uri() . DIRECTORY_SEPARATOR . $this->themeSlug . '/static/css/' . $this->themeSlug . '-admin.css', [],
            wp_get_theme()->get('Version'));
    }

    public function registerScripts()
    {
        wp_enqueue_script($this->themeSlug . '-manifest', get_theme_root_uri() . DIRECTORY_SEPARATOR . $this->themeSlug . '/static/js/manifest.js', [], wp_get_theme()->get('Version'), true);
        wp_enqueue_script($this->themeSlug . '-vendor', get_theme_root_uri() . DIRECTORY_SEPARATOR . $this->themeSlug . '/static/js/vendor.js', [$this->themeSlug . '-manifest'], wp_get_theme()->get('Version'), true);
        wp_enqueue_script($this->themeSlug . '-app', get_theme_root_uri() . DIRECTORY_SEPARATOR . $this->themeSlug . '/static/js/app.js', [$this->themeSlug . '-vendor'], wp_get_theme()->get('Version'), true);
    }


    public function registerWidgetAreas()
    {
        for ($i = 1; $i <= $this->footerColumns; $i++) {

            register_sidebar(array(
                'id' => "footer-$i",
                'before_widget' => '<div class="widget widget--footer %2$s column-'.$i.'">',
                'after_widget' => '</div>',
                'before_title' => '<div class="widget-title">',
                'after_title' => '</div>',
                'name' => __('Footer Spalte' . $i, 'text_domain'),
                'description' => __("Spalte $i im Footer", 'text_domain'),
            ));
        }
    }


    public function registerStyles()
    {
        wp_enqueue_style('dashicons');

        wp_enqueue_style($this->themeSlug . '-style', get_theme_root_uri() . DIRECTORY_SEPARATOR . $this->themeSlug . '/static/css/' . $this->themeSlug . '.css', ['wp-block-library'],
            wp_get_theme()->get('Version'));

    }

    public function deregisterStyles()
    {
        #wp_dequeue_style('cff');
    }

    public function registerLoginStyles()
    {
        wp_enqueue_style('login-css', get_theme_root_uri() . DIRECTORY_SEPARATOR . $this->themeSlug . '/static/css/' . $this->themeSlug . '-login.css', [],
            wp_get_theme()->get('Version'));
    }

    public function renderProductMarquee($params, $content = null)
    {
        $args = [
            "post_type" => "product",
            "posts_per_page" => "5",
            'meta_key' => 'WooCommerceEventsDate',
            'orderby' => 'meta_value',
            'order' => 'ASC',
            'meta_query' => array(
                array(
                    'key' => 'WooCommerceEventsDate',
                    'value' => date("YY-mm-dd"),
                    'compare' => '>='
                )
            )

        ];
        $context['site'] = $this;
        $context['events'] = Timber::get_posts($args);

        return Timber::compile('shortcodes/product-marquee.twig', $context);
    }

    public function renderProductTeaser($params, $content = null)
    {
        $args = [
            "post_type" => "product",
            "posts_per_page" => "5",
        ];

        $args = array(
            'post_type' => 'product',
            'posts_per_page' => '-1',
            'meta_key' => 'WooCommerceEventsDate',
            'orderby' => 'meta_value',
            'order' => 'ASC',
            'meta_query' => array(
                array(
                    'key' => 'WooCommerceEventsDate',
                    'value' => date("YY-mm-dd"),
                    'compare' => '>='
                )
            )
        );


        $context['site'] = $this;
        $context['events'] = Timber::get_posts($args);

        return Timber::compile('shortcodes/product-teaser.twig', $context);
    }

}

include 'updater/theme-updater.php';

new DieKochLocationSite();
