@servers(['production' => 'ssh-w0155981@w0155981.kasserver.com','stageing' => 'ssh-w0155981@w0155981.kasserver.com'])

@setup
$repository = "ssh://git@gitlab.amadeus-agentur.com:93/krumpholz/website-project.git";

$path_production = "w014649f";
$path_stageing = "w0155981 ";


if($on == "production")
{
die("NO PRODUCTION ENV SET");
$releases_dir = "/www/htdocs/w014649f/meldebogen.amadeus-verlag.net/releases";
$app_dir = "/www/htdocs/w014649f/meldebogen.amadeus-verlag.net";
}
elseif($on == "stageing")
{
$releases_dir = "/www/htdocs/w0155981/website.by.amadeus-agentur.com/releases";
$app_dir = "/www/htdocs/w0155981/website.by.amadeus-agentur.com";
}

if($release != null && $release != '' )
{
    $app_release = $release;
}
else $app_release = date('YmdHis');


$new_release_dir = $releases_dir .'/'. $app_release;
@endsetup


@story('deploy',["on" => $on])
clone_repository
run_composer
update_symlinks
@endstory


@task('clone_repository')
echo 'Cloning repository'
echo 'Version: {{$app_release}}';
[ -d {{ $new_release_dir }} ] || mkdir -p {{ $new_release_dir }}
git clone --depth 1 {{ $repository }} {{ $new_release_dir }}

@endtask

@task('run_composer')
echo "Starting deployment ({{ $app_release }})"
cd {{ $new_release_dir }}
php72 {{$app_dir}}/../bin/composer.phar install --no-dev --prefer-dist --no-scripts -q -o
@endtask

@task('update_symlinks')

echo "Linking uploads directory"
rm -rf {{ $new_release_dir }}/web/app/uploads
ln -nfs {{ $app_dir }}/uploads {{ $new_release_dir }}/web/app/uploads

echo 'Linking .env file'
ln -nfs {{ $app_dir }}/.env {{ $new_release_dir }}/.env

echo 'Linking current release'
ln -nfs {{ $new_release_dir }} {{ $app_dir }}/current
@endtask
