var klaroConfig = {
    cookieExpiresAfterDays: 365,
    default: true,
    mustConsent: false,
    htmlTexts: true,
    styling: {
        theme: ['dark', 'top', 'wide'],
        blue1: '#E4007D',
        dark1: '#212529FF',
        dark2: '#E4007D',
        green1: '#E4007D',
    },
    translations: {
        // If you erase the "consentModal" translations, Klaro will use the
        // bundled translations.
        de: {
            ok: 'Alle akzeptieren und weiter ›',
            acceptAll: 'Alle akzeptieren und weiter ›',
            privacyPolicyUrl: '/datenschutzerklaerung',
            consentNotice: {
                learnMore: 'Individuelle Einstellungen',
                description: '<span class="h3">Jepp, auch wir nutzen Cookies auf unserer Website.</span><br><br>Die technischen und funktionalen Cookies benötigen wir zwingend, damit Dein Besuch auf unserer Webseite auch funktioniert. Marketing- und personalisierte Cookies setzen wir, damit wir Dir Inhalte und Anzeigen, auch in sozialen Medien, personalisiert anbieten können, damit wir Dich auf unseren Seiten wiedererkennen und den Erfolg unserer Kampagnen messen können.<br>Um mehr zu erfahren oder deine Einwillgungserklärung zu den verwendeten Cookies anzpassen, schau bitte in unsere {privacyPolicy}.'
            },
            consentModal: {
                description:
                    'Hier kannst du anpassen, welche Technologien wir verwenden dürfen, um Information zu Deinem Nutzungsverhalten zu sammeln.',
                privacyPolicy: {
                    text: 'Um mehr zu erfahren, schau bitte in unsere {privacyPolicy}.'
                }
            }

        },
    },
    services: [
        {
            name: 'googleTagManager',
            title: 'Google Tag Manager',
            purposes: ['functional'],
            required: false,
            optOut: true,
            default: true,
            vars: {
                googleAnalytics: 'googleAnalytics'
            }
        },
        {
            name: 'googleAnalytics',
            title: 'Google Analytics',
            purposes: ['analytics'],
            cookies: [/^_ga(_.*)?/],
            callback: function (consent, app) {
                if (consent !== false) {
                    dataLayer.push({'event': 'loadgtm-analytics'})
                }
            },
        },
    ],
};

if (typeof klaroConfigTranslations !== 'undefined') {
    for (var attr in klaroConfigTranslations) {
        klaroConfig[attr] = klaroConfigTranslations[attr];
    }
}
