<?php
defined('TYPO3') or die('Access denied.');
call_user_func(function()
{
    /**
     * Temporary variables
     */
    $extensionKey = 'jahn_sitepackage';

    /**
     * Default PageTS for JahnSitepackage
     */
    \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::registerPageTSConfigFile(
        $extensionKey,
        'Configuration/TsConfig/Page/All.tsconfig',
        'JAHN Sitepackage'
    );
});

// Configure new fields:
$fields = array(
    'menutext1' => array(
        'label' => 'Menu Text (e.g. in Mainnavigation)',
        'exclude' => 1,
        'config' => array(
            'type' => 'text',
            'eval' => 'trim,nospace',
            'max' => 255
        ),
    ),
    'menutext2' => array(
        'label' => 'Teaser Text',
        'exclude' => 1,
        'config' => array(
            'type' => 'text',
            'eval' => 'trim,nospace',
            'max' => 255
        ),
    ),
    'teaser_image' => [
        'exclude' => true,
        'label' => 'Teaser Image',
        'config' => \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::getFileFieldTCAConfig(
            'teaser_image',
            [
                // Use the imageoverlayPalette instead of the basicoverlayPalette
                'overrideChildTca' => [
                    'types' => [
                        '0' => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ],
                        \TYPO3\CMS\Core\Resource\File::FILETYPE_IMAGE => [
                            'showitem' => '
                                    --palette--;;imageoverlayPalette,
                                    --palette--;;filePalette'
                        ]
                    ],
                    'columns' => [
                        'crop' => [
                            'config' => [
                                'cropVariants' => [
                                    'default' => [
                                        'disabled' => true,
                                    ],
                                    'teaser' => [
                                        'title' => 'Teaser',
                                        'coverAreas' => [],
                                        'cropArea' => [
                                            'x' => '0.0',
                                            'y' => '0.0',
                                            'width' => '1.0',
                                            'height' => '1.0'
                                        ],
                                        'allowedAspectRatios' => [
                                            '3:2' => [
                                                'title' => '3:2',
                                                'value' => 3 / 2
                                            ],
                                            'NaN' => [
                                                'title' => 'LLL:EXT:core/Resources/Private/Language/locallang_wizards.xlf:imwizard.ratio.free',
                                                'value' => 0.0
                                            ],
                                        ],
                                        'selectedRatio' => '3:2',
                                    ],
                                ],
                            ],
                        ]
                    ]
                ],
                'behaviour' => [
                    'allowLanguageSynchronization' => true
                ]
            ],
            $GLOBALS['TYPO3_CONF_VARS']['GFX']['imagefile_ext']
        )
    ]
);


// Add new fields to pages:
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addTCAcolumns('pages', $fields);

// Make fields visible in the TCEforms:
\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::addToAllTCAtypes(
    'pages', // Table name
    '--palette--;Additional Infos;additional_infos', // Field list to add
    '', // List of specific types to add the field list to. (If empty, all type entries are affected)
    'after:title' // Insert fields before (default) or after one, or replace a field
);

// Add the new palette:
$GLOBALS['TCA']['pages']['palettes']['additional_infos'] = array(
    'showitem' => 'menutext1,--linebreak--,menutext2,--linebreak--,teaser_image'
);
