'use strict';
/* File: gulpfile.js */

// grab our gulp packages
const {src, dest, watch, series, parallel} = require('gulp'),
    path = require('path'),
    del = require('del'),
    browser = require('browser-sync').create(),
    gulpif = require('gulp-if'),
    // babel = require('gulp-babel'),
    autoprefixer = require('gulp-autoprefixer'),
    cleanCSS = require('gulp-clean-css'),
    sass = require('gulp-dart-sass'),
    plumber = require('gulp-plumber'),
    sourcemaps = require('gulp-sourcemaps'),
    webpack = require('webpack'),
    webpackStream = require('webpack-stream')


let paths = {
    private: '../Resources/Private/',
    public: '../Resources/Public/',
    styles: {
        src: '../Resources/Private/Scss/',
        dest: '../Resources/Public/Css/'
    },
    scripts: {
        src: '../Resources/Private/JavaScript/',
        dest: '../Resources/Public/JavaScript/'
    },
    node_modules: "./node_modules/"

};

let project = {
    // devurl: 'https://serag.ddev.site',
    devurl: 'https://127.0.0.1:58277',
    //liveurl: 'https://serag-wiessner.info',
    extname: 'jahn_sitepackage',
    extdir: 'typo3conf/ext/' + this.extname + '/Resources/Public',
    additionalWatchedFolders: []
}


// environmental settings for production/deployment

const isProduction = (process.argv[3] == "--production"),
    environment = (process.argv[4] == "--live" ? project.liveurl : project.devurl);


function clean(done) {
    del([
        paths.styles.dest + '**/*',
        paths.scripts.dest + '**/*'
    ], {
        force: true
    });
    done();
}


// Less to CSS: Run manually with: "gulp build-css"
function stylesheet() {
    return src([paths.styles.src + 'theme.scss', paths.styles.src + 'rte.scss'])
        .pipe(gulpif(!isProduction, sourcemaps.init()))
        .pipe(sass.sync({
            includePaths: [paths.node_modules]
        }))
        .pipe(autoprefixer())
        .pipe(gulpif(isProduction, cleanCSS({
                level: 1,
                format: (isProduction ? 'none' : 'beautify'),
            }, function (details) {
                console.log(details.name + ': ' + (details.stats.originalSize / 1024).toFixed(2) + '/' + (details.stats.minifiedSize / 1024).toFixed(2) + ' KB' + ' (-' + (details.stats.efficiency * 100).toFixed(2) + '%)')
            }
        )))
        .pipe(gulpif(!isProduction, sourcemaps.write('./')))
        .pipe(dest(paths.styles.dest))
        .pipe(browser.stream())
}


function javascript() {
    return webpackStream({
        entry: {
            'bootstrap': paths.node_modules + 'bootstrap/dist/js/bootstrap.js',
            'jquery': paths.node_modules + 'jquery/dist/jquery.js',
            'app': paths.scripts.src + 'app.js'
        },
        output: {
            filename: '[name].min.js',
        },
        watch: !isProduction,
        mode: (isProduction ? "production" : "development"),
        resolve: {
            modules: [path.resolve(__dirname, 'node_modules'), 'node_modules'],
        }
    }, webpack)
        .pipe(plumber())
        .pipe(dest(paths.scripts.dest))
        .pipe(browser.stream())
}

function copy3rdParty() {

    var scripts = src(
        [
            paths.node_modules + 'imagesloaded/imagesloaded.pkgd.js',
            paths.node_modules + 'hammerjs/hammer.min.js',
            paths.node_modules + 'mmenu-js/dist/mmenu.js',
            paths.scripts.src + 'klaro.conf7.js'
        ]
    )

        .pipe(dest(paths.scripts.dest))

    return (scripts);
}


function server(done) {
    browser.init({
        open: false,
        online: true,
        reloadOnRestart: true,
        logConnections: true,
        proxy: environment,
        notify: {
            styles: {
                top: 'auto',
                bottom: '0',
                borderRadius: '5px 0px 0px'
            }
        }
    });
    done();
}


function watcherHtml() {
    watch([].concat(paths.private + '**/*.html', project.additionalWatchedFolders + '**/*.html')).on('all', browser.reload);
}

function watcherJS() {
    watch(paths.scripts.src + '**/*', {ignoreInitial: false}, javascript);
}

function watcherStyles() {
    watch([paths.styles.src + '**/*.scss', paths.public + 'Fonts/**/*.scss'], {ignoreInitial: false}, stylesheet);
}


exports.build = series(clean, parallel(stylesheet, javascript, copy3rdParty));

exports.default = series(server, parallel(watcherJS, watcherStyles, watcherHtml));
